// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A set of Azure Batch account keys.
 */
@Immutable
public final class BatchAccountKeysInner implements JsonSerializable<BatchAccountKeysInner> {
    /*
     * The Batch account name.
     */
    private String accountName;

    /*
     * The primary key associated with the account.
     */
    private String primary;

    /*
     * The secondary key associated with the account.
     */
    private String secondary;

    /**
     * Creates an instance of BatchAccountKeysInner class.
     */
    public BatchAccountKeysInner() {
    }

    /**
     * Get the accountName property: The Batch account name.
     * 
     * @return the accountName value.
     */
    public String accountName() {
        return this.accountName;
    }

    /**
     * Get the primary property: The primary key associated with the account.
     * 
     * @return the primary value.
     */
    public String primary() {
        return this.primary;
    }

    /**
     * Get the secondary property: The secondary key associated with the account.
     * 
     * @return the secondary value.
     */
    public String secondary() {
        return this.secondary;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BatchAccountKeysInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BatchAccountKeysInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the BatchAccountKeysInner.
     */
    public static BatchAccountKeysInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BatchAccountKeysInner deserializedBatchAccountKeysInner = new BatchAccountKeysInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("accountName".equals(fieldName)) {
                    deserializedBatchAccountKeysInner.accountName = reader.getString();
                } else if ("primary".equals(fieldName)) {
                    deserializedBatchAccountKeysInner.primary = reader.getString();
                } else if ("secondary".equals(fieldName)) {
                    deserializedBatchAccountKeysInner.secondary = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBatchAccountKeysInner;
        });
    }
}
