// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Quotas associated with a Batch region for a particular subscription.
 */
@Immutable
public final class BatchLocationQuotaInner implements JsonSerializable<BatchLocationQuotaInner> {
    /*
     * The number of Batch accounts that may be created under the subscription in the specified region.
     */
    private Integer accountQuota;

    /**
     * Creates an instance of BatchLocationQuotaInner class.
     */
    public BatchLocationQuotaInner() {
    }

    /**
     * Get the accountQuota property: The number of Batch accounts that may be created under the subscription in the
     * specified region.
     * 
     * @return the accountQuota value.
     */
    public Integer accountQuota() {
        return this.accountQuota;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BatchLocationQuotaInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BatchLocationQuotaInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the BatchLocationQuotaInner.
     */
    public static BatchLocationQuotaInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BatchLocationQuotaInner deserializedBatchLocationQuotaInner = new BatchLocationQuotaInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("accountQuota".equals(fieldName)) {
                    deserializedBatchLocationQuotaInner.accountQuota = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBatchLocationQuotaInner;
        });
    }
}
