// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.CertificateBaseProperties;
import com.azure.resourcemanager.batch.models.CertificateFormat;
import java.io.IOException;

/**
 * Certificate properties for create operations.
 */
@Fluent
public final class CertificateCreateOrUpdateProperties extends CertificateBaseProperties {
    /*
     * The maximum size is 10KB.
     */
    private String data;

    /*
     * This must not be specified if the certificate format is Cer.
     */
    private String password;

    /**
     * Creates an instance of CertificateCreateOrUpdateProperties class.
     */
    public CertificateCreateOrUpdateProperties() {
    }

    /**
     * Get the data property: The maximum size is 10KB.
     * 
     * @return the data value.
     */
    public String data() {
        return this.data;
    }

    /**
     * Set the data property: The maximum size is 10KB.
     * 
     * @param data the data value to set.
     * @return the CertificateCreateOrUpdateProperties object itself.
     */
    public CertificateCreateOrUpdateProperties withData(String data) {
        this.data = data;
        return this;
    }

    /**
     * Get the password property: This must not be specified if the certificate format is Cer.
     * 
     * @return the password value.
     */
    public String password() {
        return this.password;
    }

    /**
     * Set the password property: This must not be specified if the certificate format is Cer.
     * 
     * @param password the password value to set.
     * @return the CertificateCreateOrUpdateProperties object itself.
     */
    public CertificateCreateOrUpdateProperties withPassword(String password) {
        this.password = password;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CertificateCreateOrUpdateProperties withThumbprintAlgorithm(String thumbprintAlgorithm) {
        super.withThumbprintAlgorithm(thumbprintAlgorithm);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CertificateCreateOrUpdateProperties withThumbprint(String thumbprint) {
        super.withThumbprint(thumbprint);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CertificateCreateOrUpdateProperties withFormat(CertificateFormat format) {
        super.withFormat(format);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (data() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property data in model CertificateCreateOrUpdateProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CertificateCreateOrUpdateProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("thumbprintAlgorithm", thumbprintAlgorithm());
        jsonWriter.writeStringField("thumbprint", thumbprint());
        jsonWriter.writeStringField("format", format() == null ? null : format().toString());
        jsonWriter.writeStringField("data", this.data);
        jsonWriter.writeStringField("password", this.password);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CertificateCreateOrUpdateProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CertificateCreateOrUpdateProperties if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CertificateCreateOrUpdateProperties.
     */
    public static CertificateCreateOrUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CertificateCreateOrUpdateProperties deserializedCertificateCreateOrUpdateProperties
                = new CertificateCreateOrUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("thumbprintAlgorithm".equals(fieldName)) {
                    deserializedCertificateCreateOrUpdateProperties.withThumbprintAlgorithm(reader.getString());
                } else if ("thumbprint".equals(fieldName)) {
                    deserializedCertificateCreateOrUpdateProperties.withThumbprint(reader.getString());
                } else if ("format".equals(fieldName)) {
                    deserializedCertificateCreateOrUpdateProperties
                        .withFormat(CertificateFormat.fromString(reader.getString()));
                } else if ("data".equals(fieldName)) {
                    deserializedCertificateCreateOrUpdateProperties.data = reader.getString();
                } else if ("password".equals(fieldName)) {
                    deserializedCertificateCreateOrUpdateProperties.password = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCertificateCreateOrUpdateProperties;
        });
    }
}
