// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.AzureProxyResource;
import com.azure.resourcemanager.batch.models.CertificateFormat;
import com.azure.resourcemanager.batch.models.CertificateProvisioningState;
import com.azure.resourcemanager.batch.models.DeleteCertificateError;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

/**
 * Contains information about a certificate.
 */
@Fluent
public final class CertificateInner extends AzureProxyResource {
    /*
     * The properties associated with the certificate.
     */
    private CertificateProperties innerProperties;

    /*
     * The ETag of the resource, used for concurrency statements.
     */
    private String etag;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of CertificateInner class.
     */
    public CertificateInner() {
    }

    /**
     * Get the innerProperties property: The properties associated with the certificate.
     * 
     * @return the innerProperties value.
     */
    private CertificateProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the etag property: The ETag of the resource, used for concurrency statements.
     * 
     * @return the etag value.
     */
    @Override
    public String etag() {
        return this.etag;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CertificateInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioningState property.
     * 
     * @return the provisioningState value.
     */
    public CertificateProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the provisioningStateTransitionTime property: The time at which the certificate entered its current state.
     * 
     * @return the provisioningStateTransitionTime value.
     */
    public OffsetDateTime provisioningStateTransitionTime() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningStateTransitionTime();
    }

    /**
     * Get the previousProvisioningState property: The previous provisioned state of the resource.
     * 
     * @return the previousProvisioningState value.
     */
    public CertificateProvisioningState previousProvisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().previousProvisioningState();
    }

    /**
     * Get the previousProvisioningStateTransitionTime property: The time at which the certificate entered its previous
     * state.
     * 
     * @return the previousProvisioningStateTransitionTime value.
     */
    public OffsetDateTime previousProvisioningStateTransitionTime() {
        return this.innerProperties() == null ? null : this.innerProperties().previousProvisioningStateTransitionTime();
    }

    /**
     * Get the publicData property: The public key of the certificate.
     * 
     * @return the publicData value.
     */
    public String publicData() {
        return this.innerProperties() == null ? null : this.innerProperties().publicData();
    }

    /**
     * Get the deleteCertificateError property: This is only returned when the certificate provisioningState is
     * 'Failed'.
     * 
     * @return the deleteCertificateError value.
     */
    public DeleteCertificateError deleteCertificateError() {
        return this.innerProperties() == null ? null : this.innerProperties().deleteCertificateError();
    }

    /**
     * Get the thumbprintAlgorithm property: This must match the first portion of the certificate name. Currently
     * required to be 'SHA1'.
     * 
     * @return the thumbprintAlgorithm value.
     */
    public String thumbprintAlgorithm() {
        return this.innerProperties() == null ? null : this.innerProperties().thumbprintAlgorithm();
    }

    /**
     * Set the thumbprintAlgorithm property: This must match the first portion of the certificate name. Currently
     * required to be 'SHA1'.
     * 
     * @param thumbprintAlgorithm the thumbprintAlgorithm value to set.
     * @return the CertificateInner object itself.
     */
    public CertificateInner withThumbprintAlgorithm(String thumbprintAlgorithm) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CertificateProperties();
        }
        this.innerProperties().withThumbprintAlgorithm(thumbprintAlgorithm);
        return this;
    }

    /**
     * Get the thumbprint property: This must match the thumbprint from the name.
     * 
     * @return the thumbprint value.
     */
    public String thumbprint() {
        return this.innerProperties() == null ? null : this.innerProperties().thumbprint();
    }

    /**
     * Set the thumbprint property: This must match the thumbprint from the name.
     * 
     * @param thumbprint the thumbprint value to set.
     * @return the CertificateInner object itself.
     */
    public CertificateInner withThumbprint(String thumbprint) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CertificateProperties();
        }
        this.innerProperties().withThumbprint(thumbprint);
        return this;
    }

    /**
     * Get the format property: The format of the certificate - either Pfx or Cer. If omitted, the default is Pfx.
     * 
     * @return the format value.
     */
    public CertificateFormat format() {
        return this.innerProperties() == null ? null : this.innerProperties().format();
    }

    /**
     * Set the format property: The format of the certificate - either Pfx or Cer. If omitted, the default is Pfx.
     * 
     * @param format the format value to set.
     * @return the CertificateInner object itself.
     */
    public CertificateInner withFormat(CertificateFormat format) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CertificateProperties();
        }
        this.innerProperties().withFormat(format);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CertificateInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CertificateInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CertificateInner.
     */
    public static CertificateInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CertificateInner deserializedCertificateInner = new CertificateInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedCertificateInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedCertificateInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedCertificateInner.type = reader.getString();
                } else if ("etag".equals(fieldName)) {
                    deserializedCertificateInner.etag = reader.getString();
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedCertificateInner.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedCertificateInner.innerProperties = CertificateProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCertificateInner;
        });
    }
}
