// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.CertificateBaseProperties;
import com.azure.resourcemanager.batch.models.CertificateFormat;
import com.azure.resourcemanager.batch.models.CertificateProvisioningState;
import com.azure.resourcemanager.batch.models.DeleteCertificateError;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Certificate properties.
 */
@Fluent
public final class CertificateProperties extends CertificateBaseProperties {
    /*
     * The provisioningState property.
     */
    private CertificateProvisioningState provisioningState;

    /*
     * The time at which the certificate entered its current state.
     */
    private OffsetDateTime provisioningStateTransitionTime;

    /*
     * The previous provisioned state of the resource
     */
    private CertificateProvisioningState previousProvisioningState;

    /*
     * The time at which the certificate entered its previous state.
     */
    private OffsetDateTime previousProvisioningStateTransitionTime;

    /*
     * The public key of the certificate.
     */
    private String publicData;

    /*
     * This is only returned when the certificate provisioningState is 'Failed'.
     */
    private DeleteCertificateError deleteCertificateError;

    /**
     * Creates an instance of CertificateProperties class.
     */
    public CertificateProperties() {
    }

    /**
     * Get the provisioningState property: The provisioningState property.
     * 
     * @return the provisioningState value.
     */
    public CertificateProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the provisioningStateTransitionTime property: The time at which the certificate entered its current state.
     * 
     * @return the provisioningStateTransitionTime value.
     */
    public OffsetDateTime provisioningStateTransitionTime() {
        return this.provisioningStateTransitionTime;
    }

    /**
     * Get the previousProvisioningState property: The previous provisioned state of the resource.
     * 
     * @return the previousProvisioningState value.
     */
    public CertificateProvisioningState previousProvisioningState() {
        return this.previousProvisioningState;
    }

    /**
     * Get the previousProvisioningStateTransitionTime property: The time at which the certificate entered its previous
     * state.
     * 
     * @return the previousProvisioningStateTransitionTime value.
     */
    public OffsetDateTime previousProvisioningStateTransitionTime() {
        return this.previousProvisioningStateTransitionTime;
    }

    /**
     * Get the publicData property: The public key of the certificate.
     * 
     * @return the publicData value.
     */
    public String publicData() {
        return this.publicData;
    }

    /**
     * Get the deleteCertificateError property: This is only returned when the certificate provisioningState is
     * 'Failed'.
     * 
     * @return the deleteCertificateError value.
     */
    public DeleteCertificateError deleteCertificateError() {
        return this.deleteCertificateError;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CertificateProperties withThumbprintAlgorithm(String thumbprintAlgorithm) {
        super.withThumbprintAlgorithm(thumbprintAlgorithm);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CertificateProperties withThumbprint(String thumbprint) {
        super.withThumbprint(thumbprint);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CertificateProperties withFormat(CertificateFormat format) {
        super.withFormat(format);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (deleteCertificateError() != null) {
            deleteCertificateError().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("thumbprintAlgorithm", thumbprintAlgorithm());
        jsonWriter.writeStringField("thumbprint", thumbprint());
        jsonWriter.writeStringField("format", format() == null ? null : format().toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CertificateProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CertificateProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CertificateProperties.
     */
    public static CertificateProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CertificateProperties deserializedCertificateProperties = new CertificateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("thumbprintAlgorithm".equals(fieldName)) {
                    deserializedCertificateProperties.withThumbprintAlgorithm(reader.getString());
                } else if ("thumbprint".equals(fieldName)) {
                    deserializedCertificateProperties.withThumbprint(reader.getString());
                } else if ("format".equals(fieldName)) {
                    deserializedCertificateProperties.withFormat(CertificateFormat.fromString(reader.getString()));
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedCertificateProperties.provisioningState
                        = CertificateProvisioningState.fromString(reader.getString());
                } else if ("provisioningStateTransitionTime".equals(fieldName)) {
                    deserializedCertificateProperties.provisioningStateTransitionTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("previousProvisioningState".equals(fieldName)) {
                    deserializedCertificateProperties.previousProvisioningState
                        = CertificateProvisioningState.fromString(reader.getString());
                } else if ("previousProvisioningStateTransitionTime".equals(fieldName)) {
                    deserializedCertificateProperties.previousProvisioningStateTransitionTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("publicData".equals(fieldName)) {
                    deserializedCertificateProperties.publicData = reader.getString();
                } else if ("deleteCertificateError".equals(fieldName)) {
                    deserializedCertificateProperties.deleteCertificateError = DeleteCertificateError.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCertificateProperties;
        });
    }
}
