// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.NameAvailabilityReason;
import java.io.IOException;

/**
 * The CheckNameAvailability operation response.
 */
@Immutable
public final class CheckNameAvailabilityResultInner implements JsonSerializable<CheckNameAvailabilityResultInner> {
    /*
     * Gets a boolean value that indicates whether the name is available for you to use. If true, the name is available.
     * If false, the name has already been taken or invalid and cannot be used.
     */
    private Boolean nameAvailable;

    /*
     * Gets the reason that a Batch account name could not be used. The Reason element is only returned if NameAvailable
     * is false.
     */
    private NameAvailabilityReason reason;

    /*
     * Gets an error message explaining the Reason value in more detail.
     */
    private String message;

    /**
     * Creates an instance of CheckNameAvailabilityResultInner class.
     */
    public CheckNameAvailabilityResultInner() {
    }

    /**
     * Get the nameAvailable property: Gets a boolean value that indicates whether the name is available for you to use.
     * If true, the name is available. If false, the name has already been taken or invalid and cannot be used.
     * 
     * @return the nameAvailable value.
     */
    public Boolean nameAvailable() {
        return this.nameAvailable;
    }

    /**
     * Get the reason property: Gets the reason that a Batch account name could not be used. The Reason element is only
     * returned if NameAvailable is false.
     * 
     * @return the reason value.
     */
    public NameAvailabilityReason reason() {
        return this.reason;
    }

    /**
     * Get the message property: Gets an error message explaining the Reason value in more detail.
     * 
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CheckNameAvailabilityResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CheckNameAvailabilityResultInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CheckNameAvailabilityResultInner.
     */
    public static CheckNameAvailabilityResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CheckNameAvailabilityResultInner deserializedCheckNameAvailabilityResultInner
                = new CheckNameAvailabilityResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("nameAvailable".equals(fieldName)) {
                    deserializedCheckNameAvailabilityResultInner.nameAvailable
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("reason".equals(fieldName)) {
                    deserializedCheckNameAvailabilityResultInner.reason
                        = NameAvailabilityReason.fromString(reader.getString());
                } else if ("message".equals(fieldName)) {
                    deserializedCheckNameAvailabilityResultInner.message = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCheckNameAvailabilityResultInner;
        });
    }
}
