// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Detector response properties.
 */
@Fluent
public final class DetectorResponseProperties implements JsonSerializable<DetectorResponseProperties> {
    /*
     * A base64 encoded string that represents the content of a detector.
     */
    private String value;

    /**
     * Creates an instance of DetectorResponseProperties class.
     */
    public DetectorResponseProperties() {
    }

    /**
     * Get the value property: A base64 encoded string that represents the content of a detector.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: A base64 encoded string that represents the content of a detector.
     * 
     * @param value the value value to set.
     * @return the DetectorResponseProperties object itself.
     */
    public DetectorResponseProperties withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DetectorResponseProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DetectorResponseProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DetectorResponseProperties.
     */
    public static DetectorResponseProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DetectorResponseProperties deserializedDetectorResponseProperties = new DetectorResponseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    deserializedDetectorResponseProperties.value = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDetectorResponseProperties;
        });
    }
}
