// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.models.AllocationState;
import com.azure.resourcemanager.batch.models.ApplicationPackageReference;
import com.azure.resourcemanager.batch.models.AutoScaleRun;
import com.azure.resourcemanager.batch.models.CertificateReference;
import com.azure.resourcemanager.batch.models.DeploymentConfiguration;
import com.azure.resourcemanager.batch.models.InterNodeCommunicationState;
import com.azure.resourcemanager.batch.models.MetadataItem;
import com.azure.resourcemanager.batch.models.MountConfiguration;
import com.azure.resourcemanager.batch.models.NetworkConfiguration;
import com.azure.resourcemanager.batch.models.NodeCommunicationMode;
import com.azure.resourcemanager.batch.models.PoolProvisioningState;
import com.azure.resourcemanager.batch.models.ResizeOperationStatus;
import com.azure.resourcemanager.batch.models.ScaleSettings;
import com.azure.resourcemanager.batch.models.StartTask;
import com.azure.resourcemanager.batch.models.TaskSchedulingPolicy;
import com.azure.resourcemanager.batch.models.UpgradePolicy;
import com.azure.resourcemanager.batch.models.UserAccount;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

/**
 * Pool properties.
 */
@Fluent
public final class PoolProperties implements JsonSerializable<PoolProperties> {
    /*
     * The display name need not be unique and can contain any Unicode characters up to a maximum length of 1024.
     */
    private String displayName;

    /*
     * This is the last time at which the pool level data, such as the targetDedicatedNodes or autoScaleSettings,
     * changed. It does not factor in node-level changes such as a compute node changing state.
     */
    private OffsetDateTime lastModified;

    /*
     * The creation time of the pool.
     */
    private OffsetDateTime creationTime;

    /*
     * The current state of the pool.
     */
    private PoolProvisioningState provisioningState;

    /*
     * The time at which the pool entered its current state.
     */
    private OffsetDateTime provisioningStateTransitionTime;

    /*
     * Whether the pool is resizing.
     */
    private AllocationState allocationState;

    /*
     * The time at which the pool entered its current allocation state.
     */
    private OffsetDateTime allocationStateTransitionTime;

    /*
     * For information about available VM sizes, see Sizes for Virtual Machines (Linux)
     * (https://azure.microsoft.com/documentation/articles/virtual-machines-linux-sizes/) or Sizes for Virtual Machines
     * (Windows) (https://azure.microsoft.com/documentation/articles/virtual-machines-windows-sizes/). Batch supports
     * all Azure VM sizes except STANDARD_A0 and those with premium storage (STANDARD_GS, STANDARD_DS, and STANDARD_DSV2
     * series).
     */
    private String vmSize;

    /*
     * Deployment configuration properties.
     */
    private DeploymentConfiguration deploymentConfiguration;

    /*
     * The number of dedicated compute nodes currently in the pool.
     */
    private Integer currentDedicatedNodes;

    /*
     * The number of Spot/low-priority compute nodes currently in the pool.
     */
    private Integer currentLowPriorityNodes;

    /*
     * Defines the desired size of the pool. This can either be 'fixedScale' where the requested targetDedicatedNodes is
     * specified, or 'autoScale' which defines a formula which is periodically reevaluated. If this property is not
     * specified, the pool will have a fixed scale with 0 targetDedicatedNodes.
     */
    private ScaleSettings scaleSettings;

    /*
     * This property is set only if the pool automatically scales, i.e. autoScaleSettings are used.
     */
    private AutoScaleRun autoScaleRun;

    /*
     * This imposes restrictions on which nodes can be assigned to the pool. Enabling this value can reduce the chance
     * of the requested number of nodes to be allocated in the pool. If not specified, this value defaults to
     * 'Disabled'.
     */
    private InterNodeCommunicationState interNodeCommunication;

    /*
     * The network configuration for a pool.
     */
    private NetworkConfiguration networkConfiguration;

    /*
     * The default value is 1. The maximum value is the smaller of 4 times the number of cores of the vmSize of the pool
     * or 256.
     */
    private Integer taskSlotsPerNode;

    /*
     * If not specified, the default is spread.
     */
    private TaskSchedulingPolicy taskSchedulingPolicy;

    /*
     * The list of user accounts to be created on each node in the pool.
     */
    private List<UserAccount> userAccounts;

    /*
     * The Batch service does not assign any meaning to metadata; it is solely for the use of user code.
     */
    private List<MetadataItem> metadata;

    /*
     * In an PATCH (update) operation, this property can be set to an empty object to remove the start task from the
     * pool.
     */
    private StartTask startTask;

    /*
     * For Windows compute nodes, the Batch service installs the certificates to the specified certificate store and
     * location. For Linux compute nodes, the certificates are stored in a directory inside the task working directory
     * and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For
     * certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g.,
     * /home/{user-name}/certs) and certificates are placed in that directory.
     * 
     * Warning: This property is deprecated and will be removed after February, 2024. Please use the [Azure KeyVault
     * Extension](https://learn.microsoft.com/azure/batch/batch-certificate-migration-guide) instead.
     */
    private List<CertificateReference> certificates;

    /*
     * Changes to application package references affect all new compute nodes joining the pool, but do not affect
     * compute nodes that are already in the pool until they are rebooted or reimaged. There is a maximum of 10
     * application package references on any given pool.
     */
    private List<ApplicationPackageReference> applicationPackages;

    /*
     * The list of application licenses must be a subset of available Batch service application licenses. If a license
     * is requested which is not supported, pool creation will fail.
     */
    private List<String> applicationLicenses;

    /*
     * Describes either the current operation (if the pool AllocationState is Resizing) or the previously completed
     * operation (if the AllocationState is Steady).
     */
    private ResizeOperationStatus resizeOperationStatus;

    /*
     * This supports Azure Files, NFS, CIFS/SMB, and Blobfuse.
     */
    private List<MountConfiguration> mountConfiguration;

    /*
     * If omitted, the default value is Default.
     */
    private NodeCommunicationMode targetNodeCommunicationMode;

    /*
     * Determines how a pool communicates with the Batch service.
     */
    private NodeCommunicationMode currentNodeCommunicationMode;

    /*
     * Describes an upgrade policy - automatic, manual, or rolling.
     */
    private UpgradePolicy upgradePolicy;

    /*
     * The user-defined tags to be associated with the Azure Batch Pool. When specified, these tags are propagated to
     * the backing Azure resources associated with the pool. This property can only be specified when the Batch account
     * was created with the poolAllocationMode property set to 'UserSubscription'.
     */
    private Map<String, String> resourceTags;

    /**
     * Creates an instance of PoolProperties class.
     */
    public PoolProperties() {
    }

    /**
     * Get the displayName property: The display name need not be unique and can contain any Unicode characters up to a
     * maximum length of 1024.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The display name need not be unique and can contain any Unicode characters up to a
     * maximum length of 1024.
     * 
     * @param displayName the displayName value to set.
     * @return the PoolProperties object itself.
     */
    public PoolProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the lastModified property: This is the last time at which the pool level data, such as the
     * targetDedicatedNodes or autoScaleSettings, changed. It does not factor in node-level changes such as a compute
     * node changing state.
     * 
     * @return the lastModified value.
     */
    public OffsetDateTime lastModified() {
        return this.lastModified;
    }

    /**
     * Get the creationTime property: The creation time of the pool.
     * 
     * @return the creationTime value.
     */
    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    /**
     * Get the provisioningState property: The current state of the pool.
     * 
     * @return the provisioningState value.
     */
    public PoolProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the provisioningStateTransitionTime property: The time at which the pool entered its current state.
     * 
     * @return the provisioningStateTransitionTime value.
     */
    public OffsetDateTime provisioningStateTransitionTime() {
        return this.provisioningStateTransitionTime;
    }

    /**
     * Get the allocationState property: Whether the pool is resizing.
     * 
     * @return the allocationState value.
     */
    public AllocationState allocationState() {
        return this.allocationState;
    }

    /**
     * Get the allocationStateTransitionTime property: The time at which the pool entered its current allocation state.
     * 
     * @return the allocationStateTransitionTime value.
     */
    public OffsetDateTime allocationStateTransitionTime() {
        return this.allocationStateTransitionTime;
    }

    /**
     * Get the vmSize property: For information about available VM sizes, see Sizes for Virtual Machines (Linux)
     * (https://azure.microsoft.com/documentation/articles/virtual-machines-linux-sizes/) or Sizes for Virtual Machines
     * (Windows) (https://azure.microsoft.com/documentation/articles/virtual-machines-windows-sizes/). Batch supports
     * all Azure VM sizes except STANDARD_A0 and those with premium storage (STANDARD_GS, STANDARD_DS, and STANDARD_DSV2
     * series).
     * 
     * @return the vmSize value.
     */
    public String vmSize() {
        return this.vmSize;
    }

    /**
     * Set the vmSize property: For information about available VM sizes, see Sizes for Virtual Machines (Linux)
     * (https://azure.microsoft.com/documentation/articles/virtual-machines-linux-sizes/) or Sizes for Virtual Machines
     * (Windows) (https://azure.microsoft.com/documentation/articles/virtual-machines-windows-sizes/). Batch supports
     * all Azure VM sizes except STANDARD_A0 and those with premium storage (STANDARD_GS, STANDARD_DS, and STANDARD_DSV2
     * series).
     * 
     * @param vmSize the vmSize value to set.
     * @return the PoolProperties object itself.
     */
    public PoolProperties withVmSize(String vmSize) {
        this.vmSize = vmSize;
        return this;
    }

    /**
     * Get the deploymentConfiguration property: Deployment configuration properties.
     * 
     * @return the deploymentConfiguration value.
     */
    public DeploymentConfiguration deploymentConfiguration() {
        return this.deploymentConfiguration;
    }

    /**
     * Set the deploymentConfiguration property: Deployment configuration properties.
     * 
     * @param deploymentConfiguration the deploymentConfiguration value to set.
     * @return the PoolProperties object itself.
     */
    public PoolProperties withDeploymentConfiguration(DeploymentConfiguration deploymentConfiguration) {
        this.deploymentConfiguration = deploymentConfiguration;
        return this;
    }

    /**
     * Get the currentDedicatedNodes property: The number of dedicated compute nodes currently in the pool.
     * 
     * @return the currentDedicatedNodes value.
     */
    public Integer currentDedicatedNodes() {
        return this.currentDedicatedNodes;
    }

    /**
     * Get the currentLowPriorityNodes property: The number of Spot/low-priority compute nodes currently in the pool.
     * 
     * @return the currentLowPriorityNodes value.
     */
    public Integer currentLowPriorityNodes() {
        return this.currentLowPriorityNodes;
    }

    /**
     * Get the scaleSettings property: Defines the desired size of the pool. This can either be 'fixedScale' where the
     * requested targetDedicatedNodes is specified, or 'autoScale' which defines a formula which is periodically
     * reevaluated. If this property is not specified, the pool will have a fixed scale with 0 targetDedicatedNodes.
     * 
     * @return the scaleSettings value.
     */
    public ScaleSettings scaleSettings() {
        return this.scaleSettings;
    }

    /**
     * Set the scaleSettings property: Defines the desired size of the pool. This can either be 'fixedScale' where the
     * requested targetDedicatedNodes is specified, or 'autoScale' which defines a formula which is periodically
     * reevaluated. If this property is not specified, the pool will have a fixed scale with 0 targetDedicatedNodes.
     * 
     * @param scaleSettings the scaleSettings value to set.
     * @return the PoolProperties object itself.
     */
    public PoolProperties withScaleSettings(ScaleSettings scaleSettings) {
        this.scaleSettings = scaleSettings;
        return this;
    }

    /**
     * Get the autoScaleRun property: This property is set only if the pool automatically scales, i.e. autoScaleSettings
     * are used.
     * 
     * @return the autoScaleRun value.
     */
    public AutoScaleRun autoScaleRun() {
        return this.autoScaleRun;
    }

    /**
     * Get the interNodeCommunication property: This imposes restrictions on which nodes can be assigned to the pool.
     * Enabling this value can reduce the chance of the requested number of nodes to be allocated in the pool. If not
     * specified, this value defaults to 'Disabled'.
     * 
     * @return the interNodeCommunication value.
     */
    public InterNodeCommunicationState interNodeCommunication() {
        return this.interNodeCommunication;
    }

    /**
     * Set the interNodeCommunication property: This imposes restrictions on which nodes can be assigned to the pool.
     * Enabling this value can reduce the chance of the requested number of nodes to be allocated in the pool. If not
     * specified, this value defaults to 'Disabled'.
     * 
     * @param interNodeCommunication the interNodeCommunication value to set.
     * @return the PoolProperties object itself.
     */
    public PoolProperties withInterNodeCommunication(InterNodeCommunicationState interNodeCommunication) {
        this.interNodeCommunication = interNodeCommunication;
        return this;
    }

    /**
     * Get the networkConfiguration property: The network configuration for a pool.
     * 
     * @return the networkConfiguration value.
     */
    public NetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    /**
     * Set the networkConfiguration property: The network configuration for a pool.
     * 
     * @param networkConfiguration the networkConfiguration value to set.
     * @return the PoolProperties object itself.
     */
    public PoolProperties withNetworkConfiguration(NetworkConfiguration networkConfiguration) {
        this.networkConfiguration = networkConfiguration;
        return this;
    }

    /**
     * Get the taskSlotsPerNode property: The default value is 1. The maximum value is the smaller of 4 times the number
     * of cores of the vmSize of the pool or 256.
     * 
     * @return the taskSlotsPerNode value.
     */
    public Integer taskSlotsPerNode() {
        return this.taskSlotsPerNode;
    }

    /**
     * Set the taskSlotsPerNode property: The default value is 1. The maximum value is the smaller of 4 times the number
     * of cores of the vmSize of the pool or 256.
     * 
     * @param taskSlotsPerNode the taskSlotsPerNode value to set.
     * @return the PoolProperties object itself.
     */
    public PoolProperties withTaskSlotsPerNode(Integer taskSlotsPerNode) {
        this.taskSlotsPerNode = taskSlotsPerNode;
        return this;
    }

    /**
     * Get the taskSchedulingPolicy property: If not specified, the default is spread.
     * 
     * @return the taskSchedulingPolicy value.
     */
    public TaskSchedulingPolicy taskSchedulingPolicy() {
        return this.taskSchedulingPolicy;
    }

    /**
     * Set the taskSchedulingPolicy property: If not specified, the default is spread.
     * 
     * @param taskSchedulingPolicy the taskSchedulingPolicy value to set.
     * @return the PoolProperties object itself.
     */
    public PoolProperties withTaskSchedulingPolicy(TaskSchedulingPolicy taskSchedulingPolicy) {
        this.taskSchedulingPolicy = taskSchedulingPolicy;
        return this;
    }

    /**
     * Get the userAccounts property: The list of user accounts to be created on each node in the pool.
     * 
     * @return the userAccounts value.
     */
    public List<UserAccount> userAccounts() {
        return this.userAccounts;
    }

    /**
     * Set the userAccounts property: The list of user accounts to be created on each node in the pool.
     * 
     * @param userAccounts the userAccounts value to set.
     * @return the PoolProperties object itself.
     */
    public PoolProperties withUserAccounts(List<UserAccount> userAccounts) {
        this.userAccounts = userAccounts;
        return this;
    }

    /**
     * Get the metadata property: The Batch service does not assign any meaning to metadata; it is solely for the use of
     * user code.
     * 
     * @return the metadata value.
     */
    public List<MetadataItem> metadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: The Batch service does not assign any meaning to metadata; it is solely for the use of
     * user code.
     * 
     * @param metadata the metadata value to set.
     * @return the PoolProperties object itself.
     */
    public PoolProperties withMetadata(List<MetadataItem> metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * Get the startTask property: In an PATCH (update) operation, this property can be set to an empty object to remove
     * the start task from the pool.
     * 
     * @return the startTask value.
     */
    public StartTask startTask() {
        return this.startTask;
    }

    /**
     * Set the startTask property: In an PATCH (update) operation, this property can be set to an empty object to remove
     * the start task from the pool.
     * 
     * @param startTask the startTask value to set.
     * @return the PoolProperties object itself.
     */
    public PoolProperties withStartTask(StartTask startTask) {
        this.startTask = startTask;
        return this;
    }

    /**
     * Get the certificates property: For Windows compute nodes, the Batch service installs the certificates to the
     * specified certificate store and location. For Linux compute nodes, the certificates are stored in a directory
     * inside the task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task
     * to query for this location. For certificates with visibility of 'remoteUser', a 'certs' directory is created in
     * the user's home directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory.
     * 
     * Warning: This property is deprecated and will be removed after February, 2024. Please use the [Azure KeyVault
     * Extension](https://learn.microsoft.com/azure/batch/batch-certificate-migration-guide) instead.
     * 
     * @return the certificates value.
     */
    public List<CertificateReference> certificates() {
        return this.certificates;
    }

    /**
     * Set the certificates property: For Windows compute nodes, the Batch service installs the certificates to the
     * specified certificate store and location. For Linux compute nodes, the certificates are stored in a directory
     * inside the task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task
     * to query for this location. For certificates with visibility of 'remoteUser', a 'certs' directory is created in
     * the user's home directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory.
     * 
     * Warning: This property is deprecated and will be removed after February, 2024. Please use the [Azure KeyVault
     * Extension](https://learn.microsoft.com/azure/batch/batch-certificate-migration-guide) instead.
     * 
     * @param certificates the certificates value to set.
     * @return the PoolProperties object itself.
     */
    public PoolProperties withCertificates(List<CertificateReference> certificates) {
        this.certificates = certificates;
        return this;
    }

    /**
     * Get the applicationPackages property: Changes to application package references affect all new compute nodes
     * joining the pool, but do not affect compute nodes that are already in the pool until they are rebooted or
     * reimaged. There is a maximum of 10 application package references on any given pool.
     * 
     * @return the applicationPackages value.
     */
    public List<ApplicationPackageReference> applicationPackages() {
        return this.applicationPackages;
    }

    /**
     * Set the applicationPackages property: Changes to application package references affect all new compute nodes
     * joining the pool, but do not affect compute nodes that are already in the pool until they are rebooted or
     * reimaged. There is a maximum of 10 application package references on any given pool.
     * 
     * @param applicationPackages the applicationPackages value to set.
     * @return the PoolProperties object itself.
     */
    public PoolProperties withApplicationPackages(List<ApplicationPackageReference> applicationPackages) {
        this.applicationPackages = applicationPackages;
        return this;
    }

    /**
     * Get the applicationLicenses property: The list of application licenses must be a subset of available Batch
     * service application licenses. If a license is requested which is not supported, pool creation will fail.
     * 
     * @return the applicationLicenses value.
     */
    public List<String> applicationLicenses() {
        return this.applicationLicenses;
    }

    /**
     * Set the applicationLicenses property: The list of application licenses must be a subset of available Batch
     * service application licenses. If a license is requested which is not supported, pool creation will fail.
     * 
     * @param applicationLicenses the applicationLicenses value to set.
     * @return the PoolProperties object itself.
     */
    public PoolProperties withApplicationLicenses(List<String> applicationLicenses) {
        this.applicationLicenses = applicationLicenses;
        return this;
    }

    /**
     * Get the resizeOperationStatus property: Describes either the current operation (if the pool AllocationState is
     * Resizing) or the previously completed operation (if the AllocationState is Steady).
     * 
     * @return the resizeOperationStatus value.
     */
    public ResizeOperationStatus resizeOperationStatus() {
        return this.resizeOperationStatus;
    }

    /**
     * Get the mountConfiguration property: This supports Azure Files, NFS, CIFS/SMB, and Blobfuse.
     * 
     * @return the mountConfiguration value.
     */
    public List<MountConfiguration> mountConfiguration() {
        return this.mountConfiguration;
    }

    /**
     * Set the mountConfiguration property: This supports Azure Files, NFS, CIFS/SMB, and Blobfuse.
     * 
     * @param mountConfiguration the mountConfiguration value to set.
     * @return the PoolProperties object itself.
     */
    public PoolProperties withMountConfiguration(List<MountConfiguration> mountConfiguration) {
        this.mountConfiguration = mountConfiguration;
        return this;
    }

    /**
     * Get the targetNodeCommunicationMode property: If omitted, the default value is Default.
     * 
     * @return the targetNodeCommunicationMode value.
     */
    public NodeCommunicationMode targetNodeCommunicationMode() {
        return this.targetNodeCommunicationMode;
    }

    /**
     * Set the targetNodeCommunicationMode property: If omitted, the default value is Default.
     * 
     * @param targetNodeCommunicationMode the targetNodeCommunicationMode value to set.
     * @return the PoolProperties object itself.
     */
    public PoolProperties withTargetNodeCommunicationMode(NodeCommunicationMode targetNodeCommunicationMode) {
        this.targetNodeCommunicationMode = targetNodeCommunicationMode;
        return this;
    }

    /**
     * Get the currentNodeCommunicationMode property: Determines how a pool communicates with the Batch service.
     * 
     * @return the currentNodeCommunicationMode value.
     */
    public NodeCommunicationMode currentNodeCommunicationMode() {
        return this.currentNodeCommunicationMode;
    }

    /**
     * Get the upgradePolicy property: Describes an upgrade policy - automatic, manual, or rolling.
     * 
     * @return the upgradePolicy value.
     */
    public UpgradePolicy upgradePolicy() {
        return this.upgradePolicy;
    }

    /**
     * Set the upgradePolicy property: Describes an upgrade policy - automatic, manual, or rolling.
     * 
     * @param upgradePolicy the upgradePolicy value to set.
     * @return the PoolProperties object itself.
     */
    public PoolProperties withUpgradePolicy(UpgradePolicy upgradePolicy) {
        this.upgradePolicy = upgradePolicy;
        return this;
    }

    /**
     * Get the resourceTags property: The user-defined tags to be associated with the Azure Batch Pool. When specified,
     * these tags are propagated to the backing Azure resources associated with the pool. This property can only be
     * specified when the Batch account was created with the poolAllocationMode property set to 'UserSubscription'.
     * 
     * @return the resourceTags value.
     */
    public Map<String, String> resourceTags() {
        return this.resourceTags;
    }

    /**
     * Set the resourceTags property: The user-defined tags to be associated with the Azure Batch Pool. When specified,
     * these tags are propagated to the backing Azure resources associated with the pool. This property can only be
     * specified when the Batch account was created with the poolAllocationMode property set to 'UserSubscription'.
     * 
     * @param resourceTags the resourceTags value to set.
     * @return the PoolProperties object itself.
     */
    public PoolProperties withResourceTags(Map<String, String> resourceTags) {
        this.resourceTags = resourceTags;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (deploymentConfiguration() != null) {
            deploymentConfiguration().validate();
        }
        if (scaleSettings() != null) {
            scaleSettings().validate();
        }
        if (autoScaleRun() != null) {
            autoScaleRun().validate();
        }
        if (networkConfiguration() != null) {
            networkConfiguration().validate();
        }
        if (taskSchedulingPolicy() != null) {
            taskSchedulingPolicy().validate();
        }
        if (userAccounts() != null) {
            userAccounts().forEach(e -> e.validate());
        }
        if (metadata() != null) {
            metadata().forEach(e -> e.validate());
        }
        if (startTask() != null) {
            startTask().validate();
        }
        if (certificates() != null) {
            certificates().forEach(e -> e.validate());
        }
        if (applicationPackages() != null) {
            applicationPackages().forEach(e -> e.validate());
        }
        if (resizeOperationStatus() != null) {
            resizeOperationStatus().validate();
        }
        if (mountConfiguration() != null) {
            mountConfiguration().forEach(e -> e.validate());
        }
        if (upgradePolicy() != null) {
            upgradePolicy().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("vmSize", this.vmSize);
        jsonWriter.writeJsonField("deploymentConfiguration", this.deploymentConfiguration);
        jsonWriter.writeJsonField("scaleSettings", this.scaleSettings);
        jsonWriter.writeStringField("interNodeCommunication",
            this.interNodeCommunication == null ? null : this.interNodeCommunication.toString());
        jsonWriter.writeJsonField("networkConfiguration", this.networkConfiguration);
        jsonWriter.writeNumberField("taskSlotsPerNode", this.taskSlotsPerNode);
        jsonWriter.writeJsonField("taskSchedulingPolicy", this.taskSchedulingPolicy);
        jsonWriter.writeArrayField("userAccounts", this.userAccounts, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("metadata", this.metadata, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("startTask", this.startTask);
        jsonWriter.writeArrayField("certificates", this.certificates, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("applicationPackages", this.applicationPackages,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("applicationLicenses", this.applicationLicenses,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("mountConfiguration", this.mountConfiguration,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("targetNodeCommunicationMode",
            this.targetNodeCommunicationMode == null ? null : this.targetNodeCommunicationMode.toString());
        jsonWriter.writeJsonField("upgradePolicy", this.upgradePolicy);
        jsonWriter.writeMapField("resourceTags", this.resourceTags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PoolProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PoolProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the PoolProperties.
     */
    public static PoolProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PoolProperties deserializedPoolProperties = new PoolProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("displayName".equals(fieldName)) {
                    deserializedPoolProperties.displayName = reader.getString();
                } else if ("lastModified".equals(fieldName)) {
                    deserializedPoolProperties.lastModified = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("creationTime".equals(fieldName)) {
                    deserializedPoolProperties.creationTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedPoolProperties.provisioningState = PoolProvisioningState.fromString(reader.getString());
                } else if ("provisioningStateTransitionTime".equals(fieldName)) {
                    deserializedPoolProperties.provisioningStateTransitionTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("allocationState".equals(fieldName)) {
                    deserializedPoolProperties.allocationState = AllocationState.fromString(reader.getString());
                } else if ("allocationStateTransitionTime".equals(fieldName)) {
                    deserializedPoolProperties.allocationStateTransitionTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("vmSize".equals(fieldName)) {
                    deserializedPoolProperties.vmSize = reader.getString();
                } else if ("deploymentConfiguration".equals(fieldName)) {
                    deserializedPoolProperties.deploymentConfiguration = DeploymentConfiguration.fromJson(reader);
                } else if ("currentDedicatedNodes".equals(fieldName)) {
                    deserializedPoolProperties.currentDedicatedNodes = reader.getNullable(JsonReader::getInt);
                } else if ("currentLowPriorityNodes".equals(fieldName)) {
                    deserializedPoolProperties.currentLowPriorityNodes = reader.getNullable(JsonReader::getInt);
                } else if ("scaleSettings".equals(fieldName)) {
                    deserializedPoolProperties.scaleSettings = ScaleSettings.fromJson(reader);
                } else if ("autoScaleRun".equals(fieldName)) {
                    deserializedPoolProperties.autoScaleRun = AutoScaleRun.fromJson(reader);
                } else if ("interNodeCommunication".equals(fieldName)) {
                    deserializedPoolProperties.interNodeCommunication
                        = InterNodeCommunicationState.fromString(reader.getString());
                } else if ("networkConfiguration".equals(fieldName)) {
                    deserializedPoolProperties.networkConfiguration = NetworkConfiguration.fromJson(reader);
                } else if ("taskSlotsPerNode".equals(fieldName)) {
                    deserializedPoolProperties.taskSlotsPerNode = reader.getNullable(JsonReader::getInt);
                } else if ("taskSchedulingPolicy".equals(fieldName)) {
                    deserializedPoolProperties.taskSchedulingPolicy = TaskSchedulingPolicy.fromJson(reader);
                } else if ("userAccounts".equals(fieldName)) {
                    List<UserAccount> userAccounts = reader.readArray(reader1 -> UserAccount.fromJson(reader1));
                    deserializedPoolProperties.userAccounts = userAccounts;
                } else if ("metadata".equals(fieldName)) {
                    List<MetadataItem> metadata = reader.readArray(reader1 -> MetadataItem.fromJson(reader1));
                    deserializedPoolProperties.metadata = metadata;
                } else if ("startTask".equals(fieldName)) {
                    deserializedPoolProperties.startTask = StartTask.fromJson(reader);
                } else if ("certificates".equals(fieldName)) {
                    List<CertificateReference> certificates
                        = reader.readArray(reader1 -> CertificateReference.fromJson(reader1));
                    deserializedPoolProperties.certificates = certificates;
                } else if ("applicationPackages".equals(fieldName)) {
                    List<ApplicationPackageReference> applicationPackages
                        = reader.readArray(reader1 -> ApplicationPackageReference.fromJson(reader1));
                    deserializedPoolProperties.applicationPackages = applicationPackages;
                } else if ("applicationLicenses".equals(fieldName)) {
                    List<String> applicationLicenses = reader.readArray(reader1 -> reader1.getString());
                    deserializedPoolProperties.applicationLicenses = applicationLicenses;
                } else if ("resizeOperationStatus".equals(fieldName)) {
                    deserializedPoolProperties.resizeOperationStatus = ResizeOperationStatus.fromJson(reader);
                } else if ("mountConfiguration".equals(fieldName)) {
                    List<MountConfiguration> mountConfiguration
                        = reader.readArray(reader1 -> MountConfiguration.fromJson(reader1));
                    deserializedPoolProperties.mountConfiguration = mountConfiguration;
                } else if ("targetNodeCommunicationMode".equals(fieldName)) {
                    deserializedPoolProperties.targetNodeCommunicationMode
                        = NodeCommunicationMode.fromString(reader.getString());
                } else if ("currentNodeCommunicationMode".equals(fieldName)) {
                    deserializedPoolProperties.currentNodeCommunicationMode
                        = NodeCommunicationMode.fromString(reader.getString());
                } else if ("upgradePolicy".equals(fieldName)) {
                    deserializedPoolProperties.upgradePolicy = UpgradePolicy.fromJson(reader);
                } else if ("resourceTags".equals(fieldName)) {
                    Map<String, String> resourceTags = reader.readMap(reader1 -> reader1.getString());
                    deserializedPoolProperties.resourceTags = resourceTags;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPoolProperties;
        });
    }
}
