// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.batch.fluent.NetworkSecurityPerimetersClient;
import com.azure.resourcemanager.batch.fluent.models.NetworkSecurityPerimeterConfigurationInner;
import com.azure.resourcemanager.batch.models.NetworkSecurityPerimeterConfiguration;
import com.azure.resourcemanager.batch.models.NetworkSecurityPerimeters;

public final class NetworkSecurityPerimetersImpl implements NetworkSecurityPerimeters {
    private static final ClientLogger LOGGER = new ClientLogger(NetworkSecurityPerimetersImpl.class);

    private final NetworkSecurityPerimetersClient innerClient;

    private final com.azure.resourcemanager.batch.BatchManager serviceManager;

    public NetworkSecurityPerimetersImpl(NetworkSecurityPerimetersClient innerClient,
        com.azure.resourcemanager.batch.BatchManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<NetworkSecurityPerimeterConfiguration> listConfigurations(String resourceGroupName,
        String accountName) {
        PagedIterable<NetworkSecurityPerimeterConfigurationInner> inner
            = this.serviceClient().listConfigurations(resourceGroupName, accountName);
        return ResourceManagerUtils.mapPage(inner,
            inner1 -> new NetworkSecurityPerimeterConfigurationImpl(inner1, this.manager()));
    }

    public PagedIterable<NetworkSecurityPerimeterConfiguration> listConfigurations(String resourceGroupName,
        String accountName, Context context) {
        PagedIterable<NetworkSecurityPerimeterConfigurationInner> inner
            = this.serviceClient().listConfigurations(resourceGroupName, accountName, context);
        return ResourceManagerUtils.mapPage(inner,
            inner1 -> new NetworkSecurityPerimeterConfigurationImpl(inner1, this.manager()));
    }

    public Response<NetworkSecurityPerimeterConfiguration> getConfigurationWithResponse(String resourceGroupName,
        String accountName, String networkSecurityPerimeterConfigurationName, Context context) {
        Response<NetworkSecurityPerimeterConfigurationInner> inner = this.serviceClient()
            .getConfigurationWithResponse(resourceGroupName, accountName, networkSecurityPerimeterConfigurationName,
                context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new NetworkSecurityPerimeterConfigurationImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public NetworkSecurityPerimeterConfiguration getConfiguration(String resourceGroupName, String accountName,
        String networkSecurityPerimeterConfigurationName) {
        NetworkSecurityPerimeterConfigurationInner inner = this.serviceClient()
            .getConfiguration(resourceGroupName, accountName, networkSecurityPerimeterConfigurationName);
        if (inner != null) {
            return new NetworkSecurityPerimeterConfigurationImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public void reconcileConfiguration(String resourceGroupName, String accountName,
        String networkSecurityPerimeterConfigurationName) {
        this.serviceClient()
            .reconcileConfiguration(resourceGroupName, accountName, networkSecurityPerimeterConfigurationName);
    }

    public void reconcileConfiguration(String resourceGroupName, String accountName,
        String networkSecurityPerimeterConfigurationName, Context context) {
        this.serviceClient()
            .reconcileConfiguration(resourceGroupName, accountName, networkSecurityPerimeterConfigurationName, context);
    }

    private NetworkSecurityPerimetersClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.batch.BatchManager manager() {
        return this.serviceManager;
    }
}
