// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Subscription identifiers.
 */
@Fluent
public final class AccessRulePropertiesSubscriptionsItem
    implements JsonSerializable<AccessRulePropertiesSubscriptionsItem> {
    /*
     * The fully qualified Azure resource ID of the subscription e.g.
     * ('/subscriptions/00000000-0000-0000-0000-000000000000')
     */
    private String id;

    /**
     * Creates an instance of AccessRulePropertiesSubscriptionsItem class.
     */
    public AccessRulePropertiesSubscriptionsItem() {
    }

    /**
     * Get the id property: The fully qualified Azure resource ID of the subscription e.g.
     * ('/subscriptions/00000000-0000-0000-0000-000000000000').
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The fully qualified Azure resource ID of the subscription e.g.
     * ('/subscriptions/00000000-0000-0000-0000-000000000000').
     * 
     * @param id the id value to set.
     * @return the AccessRulePropertiesSubscriptionsItem object itself.
     */
    public AccessRulePropertiesSubscriptionsItem withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AccessRulePropertiesSubscriptionsItem from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AccessRulePropertiesSubscriptionsItem if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AccessRulePropertiesSubscriptionsItem.
     */
    public static AccessRulePropertiesSubscriptionsItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AccessRulePropertiesSubscriptionsItem deserializedAccessRulePropertiesSubscriptionsItem
                = new AccessRulePropertiesSubscriptionsItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedAccessRulePropertiesSubscriptionsItem.id = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAccessRulePropertiesSubscriptionsItem;
        });
    }
}
