// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * The results and errors from an execution of a pool autoscale formula.
 */
@Fluent
public final class AutoScaleRun implements JsonSerializable<AutoScaleRun> {
    /*
     * The time at which the autoscale formula was last evaluated.
     */
    private OffsetDateTime evaluationTime;

    /*
     * Each variable value is returned in the form $variable=value, and variables are separated by semicolons.
     */
    private String results;

    /*
     * An error that occurred when autoscaling a pool.
     */
    private AutoScaleRunError error;

    /**
     * Creates an instance of AutoScaleRun class.
     */
    public AutoScaleRun() {
    }

    /**
     * Get the evaluationTime property: The time at which the autoscale formula was last evaluated.
     * 
     * @return the evaluationTime value.
     */
    public OffsetDateTime evaluationTime() {
        return this.evaluationTime;
    }

    /**
     * Set the evaluationTime property: The time at which the autoscale formula was last evaluated.
     * 
     * @param evaluationTime the evaluationTime value to set.
     * @return the AutoScaleRun object itself.
     */
    public AutoScaleRun withEvaluationTime(OffsetDateTime evaluationTime) {
        this.evaluationTime = evaluationTime;
        return this;
    }

    /**
     * Get the results property: Each variable value is returned in the form $variable=value, and variables are
     * separated by semicolons.
     * 
     * @return the results value.
     */
    public String results() {
        return this.results;
    }

    /**
     * Set the results property: Each variable value is returned in the form $variable=value, and variables are
     * separated by semicolons.
     * 
     * @param results the results value to set.
     * @return the AutoScaleRun object itself.
     */
    public AutoScaleRun withResults(String results) {
        this.results = results;
        return this;
    }

    /**
     * Get the error property: An error that occurred when autoscaling a pool.
     * 
     * @return the error value.
     */
    public AutoScaleRunError error() {
        return this.error;
    }

    /**
     * Set the error property: An error that occurred when autoscaling a pool.
     * 
     * @param error the error value to set.
     * @return the AutoScaleRun object itself.
     */
    public AutoScaleRun withError(AutoScaleRunError error) {
        this.error = error;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (evaluationTime() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property evaluationTime in model AutoScaleRun"));
        }
        if (error() != null) {
            error().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AutoScaleRun.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("evaluationTime",
            this.evaluationTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.evaluationTime));
        jsonWriter.writeStringField("results", this.results);
        jsonWriter.writeJsonField("error", this.error);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AutoScaleRun from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AutoScaleRun if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AutoScaleRun.
     */
    public static AutoScaleRun fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AutoScaleRun deserializedAutoScaleRun = new AutoScaleRun();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("evaluationTime".equals(fieldName)) {
                    deserializedAutoScaleRun.evaluationTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("results".equals(fieldName)) {
                    deserializedAutoScaleRun.results = reader.getString();
                } else if ("error".equals(fieldName)) {
                    deserializedAutoScaleRun.error = AutoScaleRunError.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAutoScaleRun;
        });
    }
}
