// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * An error that occurred when autoscaling a pool.
 */
@Fluent
public final class AutoScaleRunError implements JsonSerializable<AutoScaleRunError> {
    /*
     * An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
     */
    private String code;

    /*
     * A message describing the error, intended to be suitable for display in a user interface.
     */
    private String message;

    /*
     * Additional details about the error.
     */
    private List<AutoScaleRunError> details;

    /**
     * Creates an instance of AutoScaleRunError class.
     */
    public AutoScaleRunError() {
    }

    /**
     * Get the code property: An identifier for the error. Codes are invariant and are intended to be consumed
     * programmatically.
     * 
     * @return the code value.
     */
    public String code() {
        return this.code;
    }

    /**
     * Set the code property: An identifier for the error. Codes are invariant and are intended to be consumed
     * programmatically.
     * 
     * @param code the code value to set.
     * @return the AutoScaleRunError object itself.
     */
    public AutoScaleRunError withCode(String code) {
        this.code = code;
        return this;
    }

    /**
     * Get the message property: A message describing the error, intended to be suitable for display in a user
     * interface.
     * 
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Set the message property: A message describing the error, intended to be suitable for display in a user
     * interface.
     * 
     * @param message the message value to set.
     * @return the AutoScaleRunError object itself.
     */
    public AutoScaleRunError withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Get the details property: Additional details about the error.
     * 
     * @return the details value.
     */
    public List<AutoScaleRunError> details() {
        return this.details;
    }

    /**
     * Set the details property: Additional details about the error.
     * 
     * @param details the details value to set.
     * @return the AutoScaleRunError object itself.
     */
    public AutoScaleRunError withDetails(List<AutoScaleRunError> details) {
        this.details = details;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (code() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property code in model AutoScaleRunError"));
        }
        if (message() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property message in model AutoScaleRunError"));
        }
        if (details() != null) {
            details().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AutoScaleRunError.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeArrayField("details", this.details, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AutoScaleRunError from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AutoScaleRunError if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AutoScaleRunError.
     */
    public static AutoScaleRunError fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AutoScaleRunError deserializedAutoScaleRunError = new AutoScaleRunError();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("code".equals(fieldName)) {
                    deserializedAutoScaleRunError.code = reader.getString();
                } else if ("message".equals(fieldName)) {
                    deserializedAutoScaleRunError.message = reader.getString();
                } else if ("details".equals(fieldName)) {
                    List<AutoScaleRunError> details = reader.readArray(reader1 -> AutoScaleRunError.fromJson(reader1));
                    deserializedAutoScaleRunError.details = details;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAutoScaleRunError;
        });
    }
}
