// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;

/**
 * AutoScale settings for the pool.
 */
@Fluent
public final class AutoScaleSettings implements JsonSerializable<AutoScaleSettings> {
    /*
     * A formula for the desired number of compute nodes in the pool.
     */
    private String formula;

    /*
     * If omitted, the default value is 15 minutes (PT15M).
     */
    private Duration evaluationInterval;

    /**
     * Creates an instance of AutoScaleSettings class.
     */
    public AutoScaleSettings() {
    }

    /**
     * Get the formula property: A formula for the desired number of compute nodes in the pool.
     * 
     * @return the formula value.
     */
    public String formula() {
        return this.formula;
    }

    /**
     * Set the formula property: A formula for the desired number of compute nodes in the pool.
     * 
     * @param formula the formula value to set.
     * @return the AutoScaleSettings object itself.
     */
    public AutoScaleSettings withFormula(String formula) {
        this.formula = formula;
        return this;
    }

    /**
     * Get the evaluationInterval property: If omitted, the default value is 15 minutes (PT15M).
     * 
     * @return the evaluationInterval value.
     */
    public Duration evaluationInterval() {
        return this.evaluationInterval;
    }

    /**
     * Set the evaluationInterval property: If omitted, the default value is 15 minutes (PT15M).
     * 
     * @param evaluationInterval the evaluationInterval value to set.
     * @return the AutoScaleSettings object itself.
     */
    public AutoScaleSettings withEvaluationInterval(Duration evaluationInterval) {
        this.evaluationInterval = evaluationInterval;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (formula() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property formula in model AutoScaleSettings"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AutoScaleSettings.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("formula", this.formula);
        jsonWriter.writeStringField("evaluationInterval", CoreUtils.durationToStringWithDays(this.evaluationInterval));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AutoScaleSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AutoScaleSettings if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AutoScaleSettings.
     */
    public static AutoScaleSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AutoScaleSettings deserializedAutoScaleSettings = new AutoScaleSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("formula".equals(fieldName)) {
                    deserializedAutoScaleSettings.formula = reader.getString();
                } else if ("evaluationInterval".equals(fieldName)) {
                    deserializedAutoScaleSettings.evaluationInterval
                        = reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAutoScaleSettings;
        });
    }
}
