// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Contains information about the auto-storage account associated with a Batch account.
 */
@Fluent
public final class AutoStorageProperties extends AutoStorageBaseProperties {
    /*
     * The UTC time at which storage keys were last synchronized with the Batch account.
     */
    private OffsetDateTime lastKeySync;

    /**
     * Creates an instance of AutoStorageProperties class.
     */
    public AutoStorageProperties() {
    }

    /**
     * Get the lastKeySync property: The UTC time at which storage keys were last synchronized with the Batch account.
     * 
     * @return the lastKeySync value.
     */
    public OffsetDateTime lastKeySync() {
        return this.lastKeySync;
    }

    /**
     * Set the lastKeySync property: The UTC time at which storage keys were last synchronized with the Batch account.
     * 
     * @param lastKeySync the lastKeySync value to set.
     * @return the AutoStorageProperties object itself.
     */
    public AutoStorageProperties withLastKeySync(OffsetDateTime lastKeySync) {
        this.lastKeySync = lastKeySync;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AutoStorageProperties withStorageAccountId(String storageAccountId) {
        super.withStorageAccountId(storageAccountId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AutoStorageProperties withAuthenticationMode(AutoStorageAuthenticationMode authenticationMode) {
        super.withAuthenticationMode(authenticationMode);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AutoStorageProperties withNodeIdentityReference(ComputeNodeIdentityReference nodeIdentityReference) {
        super.withNodeIdentityReference(nodeIdentityReference);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (lastKeySync() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property lastKeySync in model AutoStorageProperties"));
        }
        if (storageAccountId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property storageAccountId in model AutoStorageProperties"));
        }
        if (nodeIdentityReference() != null) {
            nodeIdentityReference().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AutoStorageProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("storageAccountId", storageAccountId());
        jsonWriter.writeStringField("authenticationMode",
            authenticationMode() == null ? null : authenticationMode().toString());
        jsonWriter.writeJsonField("nodeIdentityReference", nodeIdentityReference());
        jsonWriter.writeStringField("lastKeySync",
            this.lastKeySync == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastKeySync));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AutoStorageProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AutoStorageProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AutoStorageProperties.
     */
    public static AutoStorageProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AutoStorageProperties deserializedAutoStorageProperties = new AutoStorageProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("storageAccountId".equals(fieldName)) {
                    deserializedAutoStorageProperties.withStorageAccountId(reader.getString());
                } else if ("authenticationMode".equals(fieldName)) {
                    deserializedAutoStorageProperties
                        .withAuthenticationMode(AutoStorageAuthenticationMode.fromString(reader.getString()));
                } else if ("nodeIdentityReference".equals(fieldName)) {
                    deserializedAutoStorageProperties
                        .withNodeIdentityReference(ComputeNodeIdentityReference.fromJson(reader));
                } else if ("lastKeySync".equals(fieldName)) {
                    deserializedAutoStorageProperties.lastKeySync = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAutoStorageProperties;
        });
    }
}
