// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Specifies the parameters for the auto user that runs a task on the Batch service.
 */
@Fluent
public final class AutoUserSpecification implements JsonSerializable<AutoUserSpecification> {
    /*
     * The default value is Pool. If the pool is running Windows a value of Task should be specified if stricter
     * isolation between tasks is required. For example, if the task mutates the registry in a way which could impact
     * other tasks, or if certificates have been specified on the pool which should not be accessible by normal tasks
     * but should be accessible by start tasks.
     */
    private AutoUserScope scope;

    /*
     * The default value is nonAdmin.
     */
    private ElevationLevel elevationLevel;

    /**
     * Creates an instance of AutoUserSpecification class.
     */
    public AutoUserSpecification() {
    }

    /**
     * Get the scope property: The default value is Pool. If the pool is running Windows a value of Task should be
     * specified if stricter isolation between tasks is required. For example, if the task mutates the registry in a way
     * which could impact other tasks, or if certificates have been specified on the pool which should not be accessible
     * by normal tasks but should be accessible by start tasks.
     * 
     * @return the scope value.
     */
    public AutoUserScope scope() {
        return this.scope;
    }

    /**
     * Set the scope property: The default value is Pool. If the pool is running Windows a value of Task should be
     * specified if stricter isolation between tasks is required. For example, if the task mutates the registry in a way
     * which could impact other tasks, or if certificates have been specified on the pool which should not be accessible
     * by normal tasks but should be accessible by start tasks.
     * 
     * @param scope the scope value to set.
     * @return the AutoUserSpecification object itself.
     */
    public AutoUserSpecification withScope(AutoUserScope scope) {
        this.scope = scope;
        return this;
    }

    /**
     * Get the elevationLevel property: The default value is nonAdmin.
     * 
     * @return the elevationLevel value.
     */
    public ElevationLevel elevationLevel() {
        return this.elevationLevel;
    }

    /**
     * Set the elevationLevel property: The default value is nonAdmin.
     * 
     * @param elevationLevel the elevationLevel value to set.
     * @return the AutoUserSpecification object itself.
     */
    public AutoUserSpecification withElevationLevel(ElevationLevel elevationLevel) {
        this.elevationLevel = elevationLevel;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("scope", this.scope == null ? null : this.scope.toString());
        jsonWriter.writeStringField("elevationLevel",
            this.elevationLevel == null ? null : this.elevationLevel.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AutoUserSpecification from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AutoUserSpecification if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AutoUserSpecification.
     */
    public static AutoUserSpecification fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AutoUserSpecification deserializedAutoUserSpecification = new AutoUserSpecification();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("scope".equals(fieldName)) {
                    deserializedAutoUserSpecification.scope = AutoUserScope.fromString(reader.getString());
                } else if ("elevationLevel".equals(fieldName)) {
                    deserializedAutoUserSpecification.elevationLevel = ElevationLevel.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAutoUserSpecification;
        });
    }
}
