// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Information used to connect to an Azure Storage Container using Blobfuse.
 */
@Fluent
public final class AzureBlobFileSystemConfiguration implements JsonSerializable<AzureBlobFileSystemConfiguration> {
    /*
     * The Azure Storage Account name.
     */
    private String accountName;

    /*
     * The Azure Blob Storage Container name.
     */
    private String containerName;

    /*
     * This property is mutually exclusive with both sasKey and identity; exactly one must be specified.
     */
    private String accountKey;

    /*
     * This property is mutually exclusive with both accountKey and identity; exactly one must be specified.
     */
    private String sasKey;

    /*
     * These are 'net use' options in Windows and 'mount' options in Linux.
     */
    private String blobfuseOptions;

    /*
     * All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR
     * environment variable.
     */
    private String relativeMountPath;

    /*
     * This property is mutually exclusive with both accountKey and sasKey; exactly one must be specified.
     */
    private ComputeNodeIdentityReference identityReference;

    /**
     * Creates an instance of AzureBlobFileSystemConfiguration class.
     */
    public AzureBlobFileSystemConfiguration() {
    }

    /**
     * Get the accountName property: The Azure Storage Account name.
     * 
     * @return the accountName value.
     */
    public String accountName() {
        return this.accountName;
    }

    /**
     * Set the accountName property: The Azure Storage Account name.
     * 
     * @param accountName the accountName value to set.
     * @return the AzureBlobFileSystemConfiguration object itself.
     */
    public AzureBlobFileSystemConfiguration withAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    /**
     * Get the containerName property: The Azure Blob Storage Container name.
     * 
     * @return the containerName value.
     */
    public String containerName() {
        return this.containerName;
    }

    /**
     * Set the containerName property: The Azure Blob Storage Container name.
     * 
     * @param containerName the containerName value to set.
     * @return the AzureBlobFileSystemConfiguration object itself.
     */
    public AzureBlobFileSystemConfiguration withContainerName(String containerName) {
        this.containerName = containerName;
        return this;
    }

    /**
     * Get the accountKey property: This property is mutually exclusive with both sasKey and identity; exactly one must
     * be specified.
     * 
     * @return the accountKey value.
     */
    public String accountKey() {
        return this.accountKey;
    }

    /**
     * Set the accountKey property: This property is mutually exclusive with both sasKey and identity; exactly one must
     * be specified.
     * 
     * @param accountKey the accountKey value to set.
     * @return the AzureBlobFileSystemConfiguration object itself.
     */
    public AzureBlobFileSystemConfiguration withAccountKey(String accountKey) {
        this.accountKey = accountKey;
        return this;
    }

    /**
     * Get the sasKey property: This property is mutually exclusive with both accountKey and identity; exactly one must
     * be specified.
     * 
     * @return the sasKey value.
     */
    public String sasKey() {
        return this.sasKey;
    }

    /**
     * Set the sasKey property: This property is mutually exclusive with both accountKey and identity; exactly one must
     * be specified.
     * 
     * @param sasKey the sasKey value to set.
     * @return the AzureBlobFileSystemConfiguration object itself.
     */
    public AzureBlobFileSystemConfiguration withSasKey(String sasKey) {
        this.sasKey = sasKey;
        return this;
    }

    /**
     * Get the blobfuseOptions property: These are 'net use' options in Windows and 'mount' options in Linux.
     * 
     * @return the blobfuseOptions value.
     */
    public String blobfuseOptions() {
        return this.blobfuseOptions;
    }

    /**
     * Set the blobfuseOptions property: These are 'net use' options in Windows and 'mount' options in Linux.
     * 
     * @param blobfuseOptions the blobfuseOptions value to set.
     * @return the AzureBlobFileSystemConfiguration object itself.
     */
    public AzureBlobFileSystemConfiguration withBlobfuseOptions(String blobfuseOptions) {
        this.blobfuseOptions = blobfuseOptions;
        return this;
    }

    /**
     * Get the relativeMountPath property: All file systems are mounted relative to the Batch mounts directory,
     * accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
     * 
     * @return the relativeMountPath value.
     */
    public String relativeMountPath() {
        return this.relativeMountPath;
    }

    /**
     * Set the relativeMountPath property: All file systems are mounted relative to the Batch mounts directory,
     * accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
     * 
     * @param relativeMountPath the relativeMountPath value to set.
     * @return the AzureBlobFileSystemConfiguration object itself.
     */
    public AzureBlobFileSystemConfiguration withRelativeMountPath(String relativeMountPath) {
        this.relativeMountPath = relativeMountPath;
        return this;
    }

    /**
     * Get the identityReference property: This property is mutually exclusive with both accountKey and sasKey; exactly
     * one must be specified.
     * 
     * @return the identityReference value.
     */
    public ComputeNodeIdentityReference identityReference() {
        return this.identityReference;
    }

    /**
     * Set the identityReference property: This property is mutually exclusive with both accountKey and sasKey; exactly
     * one must be specified.
     * 
     * @param identityReference the identityReference value to set.
     * @return the AzureBlobFileSystemConfiguration object itself.
     */
    public AzureBlobFileSystemConfiguration withIdentityReference(ComputeNodeIdentityReference identityReference) {
        this.identityReference = identityReference;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (accountName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property accountName in model AzureBlobFileSystemConfiguration"));
        }
        if (containerName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property containerName in model AzureBlobFileSystemConfiguration"));
        }
        if (relativeMountPath() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property relativeMountPath in model AzureBlobFileSystemConfiguration"));
        }
        if (identityReference() != null) {
            identityReference().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AzureBlobFileSystemConfiguration.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("accountName", this.accountName);
        jsonWriter.writeStringField("containerName", this.containerName);
        jsonWriter.writeStringField("relativeMountPath", this.relativeMountPath);
        jsonWriter.writeStringField("accountKey", this.accountKey);
        jsonWriter.writeStringField("sasKey", this.sasKey);
        jsonWriter.writeStringField("blobfuseOptions", this.blobfuseOptions);
        jsonWriter.writeJsonField("identityReference", this.identityReference);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureBlobFileSystemConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureBlobFileSystemConfiguration if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AzureBlobFileSystemConfiguration.
     */
    public static AzureBlobFileSystemConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureBlobFileSystemConfiguration deserializedAzureBlobFileSystemConfiguration
                = new AzureBlobFileSystemConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("accountName".equals(fieldName)) {
                    deserializedAzureBlobFileSystemConfiguration.accountName = reader.getString();
                } else if ("containerName".equals(fieldName)) {
                    deserializedAzureBlobFileSystemConfiguration.containerName = reader.getString();
                } else if ("relativeMountPath".equals(fieldName)) {
                    deserializedAzureBlobFileSystemConfiguration.relativeMountPath = reader.getString();
                } else if ("accountKey".equals(fieldName)) {
                    deserializedAzureBlobFileSystemConfiguration.accountKey = reader.getString();
                } else if ("sasKey".equals(fieldName)) {
                    deserializedAzureBlobFileSystemConfiguration.sasKey = reader.getString();
                } else if ("blobfuseOptions".equals(fieldName)) {
                    deserializedAzureBlobFileSystemConfiguration.blobfuseOptions = reader.getString();
                } else if ("identityReference".equals(fieldName)) {
                    deserializedAzureBlobFileSystemConfiguration.identityReference
                        = ComputeNodeIdentityReference.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAzureBlobFileSystemConfiguration;
        });
    }
}
