// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Information used to connect to an Azure Fileshare.
 */
@Fluent
public final class AzureFileShareConfiguration implements JsonSerializable<AzureFileShareConfiguration> {
    /*
     * The Azure Storage account name.
     */
    private String accountName;

    /*
     * This is of the form 'https://{account}.file.core.windows.net/'.
     */
    private String azureFileUrl;

    /*
     * The Azure Storage account key.
     */
    private String accountKey;

    /*
     * All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR
     * environment variable.
     */
    private String relativeMountPath;

    /*
     * These are 'net use' options in Windows and 'mount' options in Linux.
     */
    private String mountOptions;

    /**
     * Creates an instance of AzureFileShareConfiguration class.
     */
    public AzureFileShareConfiguration() {
    }

    /**
     * Get the accountName property: The Azure Storage account name.
     * 
     * @return the accountName value.
     */
    public String accountName() {
        return this.accountName;
    }

    /**
     * Set the accountName property: The Azure Storage account name.
     * 
     * @param accountName the accountName value to set.
     * @return the AzureFileShareConfiguration object itself.
     */
    public AzureFileShareConfiguration withAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    /**
     * Get the azureFileUrl property: This is of the form 'https://{account}.file.core.windows.net/'.
     * 
     * @return the azureFileUrl value.
     */
    public String azureFileUrl() {
        return this.azureFileUrl;
    }

    /**
     * Set the azureFileUrl property: This is of the form 'https://{account}.file.core.windows.net/'.
     * 
     * @param azureFileUrl the azureFileUrl value to set.
     * @return the AzureFileShareConfiguration object itself.
     */
    public AzureFileShareConfiguration withAzureFileUrl(String azureFileUrl) {
        this.azureFileUrl = azureFileUrl;
        return this;
    }

    /**
     * Get the accountKey property: The Azure Storage account key.
     * 
     * @return the accountKey value.
     */
    public String accountKey() {
        return this.accountKey;
    }

    /**
     * Set the accountKey property: The Azure Storage account key.
     * 
     * @param accountKey the accountKey value to set.
     * @return the AzureFileShareConfiguration object itself.
     */
    public AzureFileShareConfiguration withAccountKey(String accountKey) {
        this.accountKey = accountKey;
        return this;
    }

    /**
     * Get the relativeMountPath property: All file systems are mounted relative to the Batch mounts directory,
     * accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
     * 
     * @return the relativeMountPath value.
     */
    public String relativeMountPath() {
        return this.relativeMountPath;
    }

    /**
     * Set the relativeMountPath property: All file systems are mounted relative to the Batch mounts directory,
     * accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
     * 
     * @param relativeMountPath the relativeMountPath value to set.
     * @return the AzureFileShareConfiguration object itself.
     */
    public AzureFileShareConfiguration withRelativeMountPath(String relativeMountPath) {
        this.relativeMountPath = relativeMountPath;
        return this;
    }

    /**
     * Get the mountOptions property: These are 'net use' options in Windows and 'mount' options in Linux.
     * 
     * @return the mountOptions value.
     */
    public String mountOptions() {
        return this.mountOptions;
    }

    /**
     * Set the mountOptions property: These are 'net use' options in Windows and 'mount' options in Linux.
     * 
     * @param mountOptions the mountOptions value to set.
     * @return the AzureFileShareConfiguration object itself.
     */
    public AzureFileShareConfiguration withMountOptions(String mountOptions) {
        this.mountOptions = mountOptions;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (accountName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property accountName in model AzureFileShareConfiguration"));
        }
        if (azureFileUrl() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property azureFileUrl in model AzureFileShareConfiguration"));
        }
        if (accountKey() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property accountKey in model AzureFileShareConfiguration"));
        }
        if (relativeMountPath() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property relativeMountPath in model AzureFileShareConfiguration"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AzureFileShareConfiguration.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("accountName", this.accountName);
        jsonWriter.writeStringField("azureFileUrl", this.azureFileUrl);
        jsonWriter.writeStringField("accountKey", this.accountKey);
        jsonWriter.writeStringField("relativeMountPath", this.relativeMountPath);
        jsonWriter.writeStringField("mountOptions", this.mountOptions);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureFileShareConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureFileShareConfiguration if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AzureFileShareConfiguration.
     */
    public static AzureFileShareConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureFileShareConfiguration deserializedAzureFileShareConfiguration = new AzureFileShareConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("accountName".equals(fieldName)) {
                    deserializedAzureFileShareConfiguration.accountName = reader.getString();
                } else if ("azureFileUrl".equals(fieldName)) {
                    deserializedAzureFileShareConfiguration.azureFileUrl = reader.getString();
                } else if ("accountKey".equals(fieldName)) {
                    deserializedAzureFileShareConfiguration.accountKey = reader.getString();
                } else if ("relativeMountPath".equals(fieldName)) {
                    deserializedAzureFileShareConfiguration.relativeMountPath = reader.getString();
                } else if ("mountOptions".equals(fieldName)) {
                    deserializedAzureFileShareConfiguration.mountOptions = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAzureFileShareConfiguration;
        });
    }
}
