// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * A definition of an Azure resource.
 */
@Fluent
public class AzureProxyResource extends ProxyResource {
    /*
     * The ETag of the resource, used for concurrency statements.
     */
    private String etag;

    /*
     * The tags of the resource.
     */
    private Map<String, String> tags;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of AzureProxyResource class.
     */
    public AzureProxyResource() {
    }

    /**
     * Get the etag property: The ETag of the resource, used for concurrency statements.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Set the etag property: The ETag of the resource, used for concurrency statements.
     * 
     * @param etag the etag value to set.
     * @return the AzureProxyResource object itself.
     */
    AzureProxyResource withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    /**
     * Get the tags property: The tags of the resource.
     * 
     * @return the tags value.
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags property: The tags of the resource.
     * 
     * @param tags the tags value to set.
     * @return the AzureProxyResource object itself.
     */
    public AzureProxyResource withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureProxyResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureProxyResource if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AzureProxyResource.
     */
    public static AzureProxyResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureProxyResource deserializedAzureProxyResource = new AzureProxyResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedAzureProxyResource.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedAzureProxyResource.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedAzureProxyResource.type = reader.getString();
                } else if ("etag".equals(fieldName)) {
                    deserializedAzureProxyResource.etag = reader.getString();
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedAzureProxyResource.tags = tags;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAzureProxyResource;
        });
    }
}
