// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * The identity of the Batch pool, if configured. If the pool identity is updated during update an existing pool, only
 * the new vms which are created after the pool shrinks to 0 will have the updated identities.
 */
@Fluent
public final class BatchPoolIdentity implements JsonSerializable<BatchPoolIdentity> {
    /*
     * The type of identity used for the Batch Pool.
     */
    private PoolIdentityType type;

    /*
     * The list of user identities associated with the Batch pool.
     */
    private Map<String, UserAssignedIdentities> userAssignedIdentities;

    /**
     * Creates an instance of BatchPoolIdentity class.
     */
    public BatchPoolIdentity() {
    }

    /**
     * Get the type property: The type of identity used for the Batch Pool.
     * 
     * @return the type value.
     */
    public PoolIdentityType type() {
        return this.type;
    }

    /**
     * Set the type property: The type of identity used for the Batch Pool.
     * 
     * @param type the type value to set.
     * @return the BatchPoolIdentity object itself.
     */
    public BatchPoolIdentity withType(PoolIdentityType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the userAssignedIdentities property: The list of user identities associated with the Batch pool.
     * 
     * @return the userAssignedIdentities value.
     */
    public Map<String, UserAssignedIdentities> userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    /**
     * Set the userAssignedIdentities property: The list of user identities associated with the Batch pool.
     * 
     * @param userAssignedIdentities the userAssignedIdentities value to set.
     * @return the BatchPoolIdentity object itself.
     */
    public BatchPoolIdentity withUserAssignedIdentities(Map<String, UserAssignedIdentities> userAssignedIdentities) {
        this.userAssignedIdentities = userAssignedIdentities;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (type() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property type in model BatchPoolIdentity"));
        }
        if (userAssignedIdentities() != null) {
            userAssignedIdentities().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(BatchPoolIdentity.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeMapField("userAssignedIdentities", this.userAssignedIdentities,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BatchPoolIdentity from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BatchPoolIdentity if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the BatchPoolIdentity.
     */
    public static BatchPoolIdentity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BatchPoolIdentity deserializedBatchPoolIdentity = new BatchPoolIdentity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedBatchPoolIdentity.type = PoolIdentityType.fromString(reader.getString());
                } else if ("userAssignedIdentities".equals(fieldName)) {
                    Map<String, UserAssignedIdentities> userAssignedIdentities
                        = reader.readMap(reader1 -> UserAssignedIdentities.fromJson(reader1));
                    deserializedBatchPoolIdentity.userAssignedIdentities = userAssignedIdentities;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBatchPoolIdentity;
        });
    }
}
