// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

/**
 * The format of the certificate - either Pfx or Cer. If omitted, the default is Pfx.
 */
public enum CertificateFormat {
    /**
     * Enum value Pfx.
     */
    PFX("Pfx"),

    /**
     * Enum value Cer.
     */
    CER("Cer");

    /**
     * The actual serialized value for a CertificateFormat instance.
     */
    private final String value;

    CertificateFormat(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a CertificateFormat instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed CertificateFormat object, or null if unable to parse.
     */
    public static CertificateFormat fromString(String value) {
        if (value == null) {
            return null;
        }
        CertificateFormat[] items = CertificateFormat.values();
        for (CertificateFormat item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
