// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * A reference to a certificate to be installed on compute nodes in a pool. This must exist inside the same account as
 * the pool.
 * 
 * Warning: This object is deprecated and will be removed after February, 2024. Please use the [Azure KeyVault
 * Extension](https://learn.microsoft.com/azure/batch/batch-certificate-migration-guide) instead.
 */
@Fluent
public final class CertificateReference implements JsonSerializable<CertificateReference> {
    /*
     * The fully qualified ID of the certificate to install on the pool. This must be inside the same batch account as
     * the pool.
     */
    private String id;

    /*
     * The default value is currentUser. This property is applicable only for pools configured with Windows compute
     * nodes. For Linux compute nodes, the certificates are stored in a directory inside the task working directory and
     * an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this location. For
     * certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's home directory (e.g.,
     * /home/{user-name}/certs) and certificates are placed in that directory.
     */
    private CertificateStoreLocation storeLocation;

    /*
     * This property is applicable only for pools configured with Windows compute nodes. Common store names include: My,
     * Root, CA, Trust, Disallowed, TrustedPeople, TrustedPublisher, AuthRoot, AddressBook, but any custom store name
     * can also be used. The default value is My.
     */
    private String storeName;

    /*
     * Which user accounts on the compute node should have access to the private data of the certificate.
     */
    private List<CertificateVisibility> visibility;

    /**
     * Creates an instance of CertificateReference class.
     */
    public CertificateReference() {
    }

    /**
     * Get the id property: The fully qualified ID of the certificate to install on the pool. This must be inside the
     * same batch account as the pool.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The fully qualified ID of the certificate to install on the pool. This must be inside the
     * same batch account as the pool.
     * 
     * @param id the id value to set.
     * @return the CertificateReference object itself.
     */
    public CertificateReference withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the storeLocation property: The default value is currentUser. This property is applicable only for pools
     * configured with Windows compute nodes. For Linux compute nodes, the certificates are stored in a directory inside
     * the task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query
     * for this location. For certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's
     * home directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory.
     * 
     * @return the storeLocation value.
     */
    public CertificateStoreLocation storeLocation() {
        return this.storeLocation;
    }

    /**
     * Set the storeLocation property: The default value is currentUser. This property is applicable only for pools
     * configured with Windows compute nodes. For Linux compute nodes, the certificates are stored in a directory inside
     * the task working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query
     * for this location. For certificates with visibility of 'remoteUser', a 'certs' directory is created in the user's
     * home directory (e.g., /home/{user-name}/certs) and certificates are placed in that directory.
     * 
     * @param storeLocation the storeLocation value to set.
     * @return the CertificateReference object itself.
     */
    public CertificateReference withStoreLocation(CertificateStoreLocation storeLocation) {
        this.storeLocation = storeLocation;
        return this;
    }

    /**
     * Get the storeName property: This property is applicable only for pools configured with Windows compute nodes.
     * Common store names include: My, Root, CA, Trust, Disallowed, TrustedPeople, TrustedPublisher, AuthRoot,
     * AddressBook, but any custom store name can also be used. The default value is My.
     * 
     * @return the storeName value.
     */
    public String storeName() {
        return this.storeName;
    }

    /**
     * Set the storeName property: This property is applicable only for pools configured with Windows compute nodes.
     * Common store names include: My, Root, CA, Trust, Disallowed, TrustedPeople, TrustedPublisher, AuthRoot,
     * AddressBook, but any custom store name can also be used. The default value is My.
     * 
     * @param storeName the storeName value to set.
     * @return the CertificateReference object itself.
     */
    public CertificateReference withStoreName(String storeName) {
        this.storeName = storeName;
        return this;
    }

    /**
     * Get the visibility property: Which user accounts on the compute node should have access to the private data of
     * the certificate.
     * 
     * @return the visibility value.
     */
    public List<CertificateVisibility> visibility() {
        return this.visibility;
    }

    /**
     * Set the visibility property: Which user accounts on the compute node should have access to the private data of
     * the certificate.
     * 
     * @param visibility the visibility value to set.
     * @return the CertificateReference object itself.
     */
    public CertificateReference withVisibility(List<CertificateVisibility> visibility) {
        this.visibility = visibility;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (id() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property id in model CertificateReference"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CertificateReference.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("storeLocation", this.storeLocation == null ? null : this.storeLocation.toString());
        jsonWriter.writeStringField("storeName", this.storeName);
        jsonWriter.writeArrayField("visibility", this.visibility,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CertificateReference from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CertificateReference if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CertificateReference.
     */
    public static CertificateReference fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CertificateReference deserializedCertificateReference = new CertificateReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedCertificateReference.id = reader.getString();
                } else if ("storeLocation".equals(fieldName)) {
                    deserializedCertificateReference.storeLocation
                        = CertificateStoreLocation.fromString(reader.getString());
                } else if ("storeName".equals(fieldName)) {
                    deserializedCertificateReference.storeName = reader.getString();
                } else if ("visibility".equals(fieldName)) {
                    List<CertificateVisibility> visibility
                        = reader.readArray(reader1 -> CertificateVisibility.fromString(reader1.getString()));
                    deserializedCertificateReference.visibility = visibility;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCertificateReference;
        });
    }
}
