// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

/**
 * Defines values for CertificateVisibility.
 */
public enum CertificateVisibility {
    /**
     * Enum value StartTask.
     */
    START_TASK("StartTask"),

    /**
     * Enum value Task.
     */
    TASK("Task"),

    /**
     * Enum value RemoteUser.
     */
    REMOTE_USER("RemoteUser");

    /**
     * The actual serialized value for a CertificateVisibility instance.
     */
    private final String value;

    CertificateVisibility(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a CertificateVisibility instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed CertificateVisibility object, or null if unable to parse.
     */
    public static CertificateVisibility fromString(String value) {
        if (value == null) {
            return null;
        }
        CertificateVisibility[] items = CertificateVisibility.values();
        for (CertificateVisibility item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
