// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Information used to connect to a CIFS file system.
 */
@Fluent
public final class CifsMountConfiguration implements JsonSerializable<CifsMountConfiguration> {
    /*
     * The user to use for authentication against the CIFS file system.
     */
    private String username;

    /*
     * The URI of the file system to mount.
     */
    private String source;

    /*
     * All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR
     * environment variable.
     */
    private String relativeMountPath;

    /*
     * These are 'net use' options in Windows and 'mount' options in Linux.
     */
    private String mountOptions;

    /*
     * The password to use for authentication against the CIFS file system.
     */
    private String password;

    /**
     * Creates an instance of CifsMountConfiguration class.
     */
    public CifsMountConfiguration() {
    }

    /**
     * Get the username property: The user to use for authentication against the CIFS file system.
     * 
     * @return the username value.
     */
    public String username() {
        return this.username;
    }

    /**
     * Set the username property: The user to use for authentication against the CIFS file system.
     * 
     * @param username the username value to set.
     * @return the CifsMountConfiguration object itself.
     */
    public CifsMountConfiguration withUsername(String username) {
        this.username = username;
        return this;
    }

    /**
     * Get the source property: The URI of the file system to mount.
     * 
     * @return the source value.
     */
    public String source() {
        return this.source;
    }

    /**
     * Set the source property: The URI of the file system to mount.
     * 
     * @param source the source value to set.
     * @return the CifsMountConfiguration object itself.
     */
    public CifsMountConfiguration withSource(String source) {
        this.source = source;
        return this;
    }

    /**
     * Get the relativeMountPath property: All file systems are mounted relative to the Batch mounts directory,
     * accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
     * 
     * @return the relativeMountPath value.
     */
    public String relativeMountPath() {
        return this.relativeMountPath;
    }

    /**
     * Set the relativeMountPath property: All file systems are mounted relative to the Batch mounts directory,
     * accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
     * 
     * @param relativeMountPath the relativeMountPath value to set.
     * @return the CifsMountConfiguration object itself.
     */
    public CifsMountConfiguration withRelativeMountPath(String relativeMountPath) {
        this.relativeMountPath = relativeMountPath;
        return this;
    }

    /**
     * Get the mountOptions property: These are 'net use' options in Windows and 'mount' options in Linux.
     * 
     * @return the mountOptions value.
     */
    public String mountOptions() {
        return this.mountOptions;
    }

    /**
     * Set the mountOptions property: These are 'net use' options in Windows and 'mount' options in Linux.
     * 
     * @param mountOptions the mountOptions value to set.
     * @return the CifsMountConfiguration object itself.
     */
    public CifsMountConfiguration withMountOptions(String mountOptions) {
        this.mountOptions = mountOptions;
        return this;
    }

    /**
     * Get the password property: The password to use for authentication against the CIFS file system.
     * 
     * @return the password value.
     */
    public String password() {
        return this.password;
    }

    /**
     * Set the password property: The password to use for authentication against the CIFS file system.
     * 
     * @param password the password value to set.
     * @return the CifsMountConfiguration object itself.
     */
    public CifsMountConfiguration withPassword(String password) {
        this.password = password;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (username() == null) {
            throw LOGGER.atError()
                .log(
                    new IllegalArgumentException("Missing required property username in model CifsMountConfiguration"));
        }
        if (source() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property source in model CifsMountConfiguration"));
        }
        if (relativeMountPath() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property relativeMountPath in model CifsMountConfiguration"));
        }
        if (password() == null) {
            throw LOGGER.atError()
                .log(
                    new IllegalArgumentException("Missing required property password in model CifsMountConfiguration"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CifsMountConfiguration.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("userName", this.username);
        jsonWriter.writeStringField("source", this.source);
        jsonWriter.writeStringField("relativeMountPath", this.relativeMountPath);
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeStringField("mountOptions", this.mountOptions);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CifsMountConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CifsMountConfiguration if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CifsMountConfiguration.
     */
    public static CifsMountConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CifsMountConfiguration deserializedCifsMountConfiguration = new CifsMountConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("userName".equals(fieldName)) {
                    deserializedCifsMountConfiguration.username = reader.getString();
                } else if ("source".equals(fieldName)) {
                    deserializedCifsMountConfiguration.source = reader.getString();
                } else if ("relativeMountPath".equals(fieldName)) {
                    deserializedCifsMountConfiguration.relativeMountPath = reader.getString();
                } else if ("password".equals(fieldName)) {
                    deserializedCifsMountConfiguration.password = reader.getString();
                } else if ("mountOptions".equals(fieldName)) {
                    deserializedCifsMountConfiguration.mountOptions = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCifsMountConfiguration;
        });
    }
}
