// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

/**
 * How tasks should be distributed across compute nodes.
 */
public enum ComputeNodeFillType {
    /**
     * Enum value Spread.
     */
    SPREAD("Spread"),

    /**
     * Enum value Pack.
     */
    PACK("Pack");

    /**
     * The actual serialized value for a ComputeNodeFillType instance.
     */
    private final String value;

    ComputeNodeFillType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a ComputeNodeFillType instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed ComputeNodeFillType object, or null if unable to parse.
     */
    public static ComputeNodeFillType fromString(String value) {
        if (value == null) {
            return null;
        }
        ComputeNodeFillType[] items = ComputeNodeFillType.values();
        for (ComputeNodeFillType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
