// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The configuration for container-enabled pools.
 */
@Fluent
public final class ContainerConfiguration implements JsonSerializable<ContainerConfiguration> {
    /*
     * The container technology to be used.
     */
    private ContainerType type;

    /*
     * This is the full image reference, as would be specified to "docker pull". An image will be sourced from the
     * default Docker registry unless the image is fully qualified with an alternative registry.
     */
    private List<String> containerImageNames;

    /*
     * If any images must be downloaded from a private registry which requires credentials, then those credentials must
     * be provided here.
     */
    private List<ContainerRegistry> containerRegistries;

    /**
     * Creates an instance of ContainerConfiguration class.
     */
    public ContainerConfiguration() {
    }

    /**
     * Get the type property: The container technology to be used.
     * 
     * @return the type value.
     */
    public ContainerType type() {
        return this.type;
    }

    /**
     * Set the type property: The container technology to be used.
     * 
     * @param type the type value to set.
     * @return the ContainerConfiguration object itself.
     */
    public ContainerConfiguration withType(ContainerType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the containerImageNames property: This is the full image reference, as would be specified to "docker pull".
     * An image will be sourced from the default Docker registry unless the image is fully qualified with an alternative
     * registry.
     * 
     * @return the containerImageNames value.
     */
    public List<String> containerImageNames() {
        return this.containerImageNames;
    }

    /**
     * Set the containerImageNames property: This is the full image reference, as would be specified to "docker pull".
     * An image will be sourced from the default Docker registry unless the image is fully qualified with an alternative
     * registry.
     * 
     * @param containerImageNames the containerImageNames value to set.
     * @return the ContainerConfiguration object itself.
     */
    public ContainerConfiguration withContainerImageNames(List<String> containerImageNames) {
        this.containerImageNames = containerImageNames;
        return this;
    }

    /**
     * Get the containerRegistries property: If any images must be downloaded from a private registry which requires
     * credentials, then those credentials must be provided here.
     * 
     * @return the containerRegistries value.
     */
    public List<ContainerRegistry> containerRegistries() {
        return this.containerRegistries;
    }

    /**
     * Set the containerRegistries property: If any images must be downloaded from a private registry which requires
     * credentials, then those credentials must be provided here.
     * 
     * @param containerRegistries the containerRegistries value to set.
     * @return the ContainerConfiguration object itself.
     */
    public ContainerConfiguration withContainerRegistries(List<ContainerRegistry> containerRegistries) {
        this.containerRegistries = containerRegistries;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (type() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property type in model ContainerConfiguration"));
        }
        if (containerRegistries() != null) {
            containerRegistries().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ContainerConfiguration.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeArrayField("containerImageNames", this.containerImageNames,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("containerRegistries", this.containerRegistries,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContainerConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContainerConfiguration if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ContainerConfiguration.
     */
    public static ContainerConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerConfiguration deserializedContainerConfiguration = new ContainerConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedContainerConfiguration.type = ContainerType.fromString(reader.getString());
                } else if ("containerImageNames".equals(fieldName)) {
                    List<String> containerImageNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedContainerConfiguration.containerImageNames = containerImageNames;
                } else if ("containerRegistries".equals(fieldName)) {
                    List<ContainerRegistry> containerRegistries
                        = reader.readArray(reader1 -> ContainerRegistry.fromJson(reader1));
                    deserializedContainerConfiguration.containerRegistries = containerRegistries;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContainerConfiguration;
        });
    }
}
