// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The entry of path and mount mode you want to mount into task container.
 */
@Fluent
public final class ContainerHostBatchBindMountEntry implements JsonSerializable<ContainerHostBatchBindMountEntry> {
    /*
     * The paths which will be mounted to container task's container.
     */
    private ContainerHostDataPath source;

    /*
     * For Linux, if you mount this path as a read/write mode, this does not mean that all users in container have the
     * read/write access for the path, it depends on the access in host VM. If this path is mounted read-only, all users
     * within the container will not be able to modify the path.
     */
    private Boolean isReadOnly;

    /**
     * Creates an instance of ContainerHostBatchBindMountEntry class.
     */
    public ContainerHostBatchBindMountEntry() {
    }

    /**
     * Get the source property: The paths which will be mounted to container task's container.
     * 
     * @return the source value.
     */
    public ContainerHostDataPath source() {
        return this.source;
    }

    /**
     * Set the source property: The paths which will be mounted to container task's container.
     * 
     * @param source the source value to set.
     * @return the ContainerHostBatchBindMountEntry object itself.
     */
    public ContainerHostBatchBindMountEntry withSource(ContainerHostDataPath source) {
        this.source = source;
        return this;
    }

    /**
     * Get the isReadOnly property: For Linux, if you mount this path as a read/write mode, this does not mean that all
     * users in container have the read/write access for the path, it depends on the access in host VM. If this path is
     * mounted read-only, all users within the container will not be able to modify the path.
     * 
     * @return the isReadOnly value.
     */
    public Boolean isReadOnly() {
        return this.isReadOnly;
    }

    /**
     * Set the isReadOnly property: For Linux, if you mount this path as a read/write mode, this does not mean that all
     * users in container have the read/write access for the path, it depends on the access in host VM. If this path is
     * mounted read-only, all users within the container will not be able to modify the path.
     * 
     * @param isReadOnly the isReadOnly value to set.
     * @return the ContainerHostBatchBindMountEntry object itself.
     */
    public ContainerHostBatchBindMountEntry withIsReadOnly(Boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("source", this.source == null ? null : this.source.toString());
        jsonWriter.writeBooleanField("isReadOnly", this.isReadOnly);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContainerHostBatchBindMountEntry from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContainerHostBatchBindMountEntry if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ContainerHostBatchBindMountEntry.
     */
    public static ContainerHostBatchBindMountEntry fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerHostBatchBindMountEntry deserializedContainerHostBatchBindMountEntry
                = new ContainerHostBatchBindMountEntry();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("source".equals(fieldName)) {
                    deserializedContainerHostBatchBindMountEntry.source
                        = ContainerHostDataPath.fromString(reader.getString());
                } else if ("isReadOnly".equals(fieldName)) {
                    deserializedContainerHostBatchBindMountEntry.isReadOnly
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContainerHostBatchBindMountEntry;
        });
    }
}
