// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Settings which will be used by the data disks associated to Compute Nodes in the Pool. When using attached data
 * disks, you need to mount and format the disks from within a VM to use them.
 */
@Fluent
public final class DataDisk implements JsonSerializable<DataDisk> {
    /*
     * The lun is used to uniquely identify each data disk. If attaching multiple disks, each should have a distinct
     * lun. The value must be between 0 and 63, inclusive.
     */
    private int lun;

    /*
     * Values are:
     * 
     * none - The caching mode for the disk is not enabled.
     * readOnly - The caching mode for the disk is read only.
     * readWrite - The caching mode for the disk is read and write.
     * 
     * The default value for caching is none. For information about the caching options see:
     * https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/.
     */
    private CachingType caching;

    /*
     * The initial disk size in GB when creating new data disk.
     */
    private int diskSizeGB;

    /*
     * If omitted, the default is "Standard_LRS". Values are:
     * 
     * Standard_LRS - The data disk should use standard locally redundant storage.
     * Premium_LRS - The data disk should use premium locally redundant storage.
     */
    private StorageAccountType storageAccountType;

    /**
     * Creates an instance of DataDisk class.
     */
    public DataDisk() {
    }

    /**
     * Get the lun property: The lun is used to uniquely identify each data disk. If attaching multiple disks, each
     * should have a distinct lun. The value must be between 0 and 63, inclusive.
     * 
     * @return the lun value.
     */
    public int lun() {
        return this.lun;
    }

    /**
     * Set the lun property: The lun is used to uniquely identify each data disk. If attaching multiple disks, each
     * should have a distinct lun. The value must be between 0 and 63, inclusive.
     * 
     * @param lun the lun value to set.
     * @return the DataDisk object itself.
     */
    public DataDisk withLun(int lun) {
        this.lun = lun;
        return this;
    }

    /**
     * Get the caching property: Values are:
     * 
     * none - The caching mode for the disk is not enabled.
     * readOnly - The caching mode for the disk is read only.
     * readWrite - The caching mode for the disk is read and write.
     * 
     * The default value for caching is none. For information about the caching options see:
     * https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/.
     * 
     * @return the caching value.
     */
    public CachingType caching() {
        return this.caching;
    }

    /**
     * Set the caching property: Values are:
     * 
     * none - The caching mode for the disk is not enabled.
     * readOnly - The caching mode for the disk is read only.
     * readWrite - The caching mode for the disk is read and write.
     * 
     * The default value for caching is none. For information about the caching options see:
     * https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/.
     * 
     * @param caching the caching value to set.
     * @return the DataDisk object itself.
     */
    public DataDisk withCaching(CachingType caching) {
        this.caching = caching;
        return this;
    }

    /**
     * Get the diskSizeGB property: The initial disk size in GB when creating new data disk.
     * 
     * @return the diskSizeGB value.
     */
    public int diskSizeGB() {
        return this.diskSizeGB;
    }

    /**
     * Set the diskSizeGB property: The initial disk size in GB when creating new data disk.
     * 
     * @param diskSizeGB the diskSizeGB value to set.
     * @return the DataDisk object itself.
     */
    public DataDisk withDiskSizeGB(int diskSizeGB) {
        this.diskSizeGB = diskSizeGB;
        return this;
    }

    /**
     * Get the storageAccountType property: If omitted, the default is "Standard_LRS". Values are:
     * 
     * Standard_LRS - The data disk should use standard locally redundant storage.
     * Premium_LRS - The data disk should use premium locally redundant storage.
     * 
     * @return the storageAccountType value.
     */
    public StorageAccountType storageAccountType() {
        return this.storageAccountType;
    }

    /**
     * Set the storageAccountType property: If omitted, the default is "Standard_LRS". Values are:
     * 
     * Standard_LRS - The data disk should use standard locally redundant storage.
     * Premium_LRS - The data disk should use premium locally redundant storage.
     * 
     * @param storageAccountType the storageAccountType value to set.
     * @return the DataDisk object itself.
     */
    public DataDisk withStorageAccountType(StorageAccountType storageAccountType) {
        this.storageAccountType = storageAccountType;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("lun", this.lun);
        jsonWriter.writeIntField("diskSizeGB", this.diskSizeGB);
        jsonWriter.writeStringField("caching", this.caching == null ? null : this.caching.toString());
        jsonWriter.writeStringField("storageAccountType",
            this.storageAccountType == null ? null : this.storageAccountType.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DataDisk from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DataDisk if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DataDisk.
     */
    public static DataDisk fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DataDisk deserializedDataDisk = new DataDisk();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("lun".equals(fieldName)) {
                    deserializedDataDisk.lun = reader.getInt();
                } else if ("diskSizeGB".equals(fieldName)) {
                    deserializedDataDisk.diskSizeGB = reader.getInt();
                } else if ("caching".equals(fieldName)) {
                    deserializedDataDisk.caching = CachingType.fromString(reader.getString());
                } else if ("storageAccountType".equals(fieldName)) {
                    deserializedDataDisk.storageAccountType = StorageAccountType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDataDisk;
        });
    }
}
