// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * An error response from the Batch service.
 */
@Fluent
public final class DeleteCertificateError implements JsonSerializable<DeleteCertificateError> {
    /*
     * An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
     */
    private String code;

    /*
     * A message describing the error, intended to be suitable for display in a user interface.
     */
    private String message;

    /*
     * The target of the particular error. For example, the name of the property in error.
     */
    private String target;

    /*
     * A list of additional details about the error.
     */
    private List<DeleteCertificateError> details;

    /**
     * Creates an instance of DeleteCertificateError class.
     */
    public DeleteCertificateError() {
    }

    /**
     * Get the code property: An identifier for the error. Codes are invariant and are intended to be consumed
     * programmatically.
     * 
     * @return the code value.
     */
    public String code() {
        return this.code;
    }

    /**
     * Set the code property: An identifier for the error. Codes are invariant and are intended to be consumed
     * programmatically.
     * 
     * @param code the code value to set.
     * @return the DeleteCertificateError object itself.
     */
    public DeleteCertificateError withCode(String code) {
        this.code = code;
        return this;
    }

    /**
     * Get the message property: A message describing the error, intended to be suitable for display in a user
     * interface.
     * 
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Set the message property: A message describing the error, intended to be suitable for display in a user
     * interface.
     * 
     * @param message the message value to set.
     * @return the DeleteCertificateError object itself.
     */
    public DeleteCertificateError withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Get the target property: The target of the particular error. For example, the name of the property in error.
     * 
     * @return the target value.
     */
    public String target() {
        return this.target;
    }

    /**
     * Set the target property: The target of the particular error. For example, the name of the property in error.
     * 
     * @param target the target value to set.
     * @return the DeleteCertificateError object itself.
     */
    public DeleteCertificateError withTarget(String target) {
        this.target = target;
        return this;
    }

    /**
     * Get the details property: A list of additional details about the error.
     * 
     * @return the details value.
     */
    public List<DeleteCertificateError> details() {
        return this.details;
    }

    /**
     * Set the details property: A list of additional details about the error.
     * 
     * @param details the details value to set.
     * @return the DeleteCertificateError object itself.
     */
    public DeleteCertificateError withDetails(List<DeleteCertificateError> details) {
        this.details = details;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (code() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property code in model DeleteCertificateError"));
        }
        if (message() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property message in model DeleteCertificateError"));
        }
        if (details() != null) {
            details().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DeleteCertificateError.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("target", this.target);
        jsonWriter.writeArrayField("details", this.details, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeleteCertificateError from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeleteCertificateError if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DeleteCertificateError.
     */
    public static DeleteCertificateError fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeleteCertificateError deserializedDeleteCertificateError = new DeleteCertificateError();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("code".equals(fieldName)) {
                    deserializedDeleteCertificateError.code = reader.getString();
                } else if ("message".equals(fieldName)) {
                    deserializedDeleteCertificateError.message = reader.getString();
                } else if ("target".equals(fieldName)) {
                    deserializedDeleteCertificateError.target = reader.getString();
                } else if ("details".equals(fieldName)) {
                    List<DeleteCertificateError> details
                        = reader.readArray(reader1 -> DeleteCertificateError.fromJson(reader1));
                    deserializedDeleteCertificateError.details = details;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeleteCertificateError;
        });
    }
}
