// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Deployment configuration properties.
 */
@Fluent
public final class DeploymentConfiguration implements JsonSerializable<DeploymentConfiguration> {
    /*
     * The configuration for compute nodes in a pool based on the Azure Virtual Machines infrastructure.
     */
    private VirtualMachineConfiguration virtualMachineConfiguration;

    /**
     * Creates an instance of DeploymentConfiguration class.
     */
    public DeploymentConfiguration() {
    }

    /**
     * Get the virtualMachineConfiguration property: The configuration for compute nodes in a pool based on the Azure
     * Virtual Machines infrastructure.
     * 
     * @return the virtualMachineConfiguration value.
     */
    public VirtualMachineConfiguration virtualMachineConfiguration() {
        return this.virtualMachineConfiguration;
    }

    /**
     * Set the virtualMachineConfiguration property: The configuration for compute nodes in a pool based on the Azure
     * Virtual Machines infrastructure.
     * 
     * @param virtualMachineConfiguration the virtualMachineConfiguration value to set.
     * @return the DeploymentConfiguration object itself.
     */
    public DeploymentConfiguration
        withVirtualMachineConfiguration(VirtualMachineConfiguration virtualMachineConfiguration) {
        this.virtualMachineConfiguration = virtualMachineConfiguration;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (virtualMachineConfiguration() != null) {
            virtualMachineConfiguration().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("virtualMachineConfiguration", this.virtualMachineConfiguration);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeploymentConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeploymentConfiguration if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DeploymentConfiguration.
     */
    public static DeploymentConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeploymentConfiguration deserializedDeploymentConfiguration = new DeploymentConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("virtualMachineConfiguration".equals(fieldName)) {
                    deserializedDeploymentConfiguration.virtualMachineConfiguration
                        = VirtualMachineConfiguration.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeploymentConfiguration;
        });
    }
}
