// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.fluent.models.DetectorResponseInner;
import java.io.IOException;
import java.util.List;

/**
 * Values returned by the List operation.
 */
@Fluent
public final class DetectorListResult implements JsonSerializable<DetectorListResult> {
    /*
     * The collection of Batch account detectors returned by the listing operation.
     */
    private List<DetectorResponseInner> value;

    /*
     * The URL to get the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of DetectorListResult class.
     */
    public DetectorListResult() {
    }

    /**
     * Get the value property: The collection of Batch account detectors returned by the listing operation.
     * 
     * @return the value value.
     */
    public List<DetectorResponseInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The collection of Batch account detectors returned by the listing operation.
     * 
     * @param value the value value to set.
     * @return the DetectorListResult object itself.
     */
    public DetectorListResult withValue(List<DetectorResponseInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to get the next set of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the DetectorListResult object itself.
     */
    public DetectorListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DetectorListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DetectorListResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the DetectorListResult.
     */
    public static DetectorListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DetectorListResult deserializedDetectorListResult = new DetectorListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<DetectorResponseInner> value
                        = reader.readArray(reader1 -> DetectorResponseInner.fromJson(reader1));
                    deserializedDetectorListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedDetectorListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDetectorListResult;
        });
    }
}
