// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The disk encryption configuration applied on compute nodes in the pool. Disk encryption configuration is not
 * supported on Linux pool created with Virtual Machine Image or Azure Compute Gallery Image.
 */
@Fluent
public final class DiskEncryptionConfiguration implements JsonSerializable<DiskEncryptionConfiguration> {
    /*
     * On Linux pool, only "TemporaryDisk" is supported; on Windows pool, "OsDisk" and "TemporaryDisk" must be
     * specified.
     */
    private List<DiskEncryptionTarget> targets;

    /**
     * Creates an instance of DiskEncryptionConfiguration class.
     */
    public DiskEncryptionConfiguration() {
    }

    /**
     * Get the targets property: On Linux pool, only "TemporaryDisk" is supported; on Windows pool, "OsDisk" and
     * "TemporaryDisk" must be specified.
     * 
     * @return the targets value.
     */
    public List<DiskEncryptionTarget> targets() {
        return this.targets;
    }

    /**
     * Set the targets property: On Linux pool, only "TemporaryDisk" is supported; on Windows pool, "OsDisk" and
     * "TemporaryDisk" must be specified.
     * 
     * @param targets the targets value to set.
     * @return the DiskEncryptionConfiguration object itself.
     */
    public DiskEncryptionConfiguration withTargets(List<DiskEncryptionTarget> targets) {
        this.targets = targets;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("targets", this.targets,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DiskEncryptionConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DiskEncryptionConfiguration if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DiskEncryptionConfiguration.
     */
    public static DiskEncryptionConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DiskEncryptionConfiguration deserializedDiskEncryptionConfiguration = new DiskEncryptionConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("targets".equals(fieldName)) {
                    List<DiskEncryptionTarget> targets
                        = reader.readArray(reader1 -> DiskEncryptionTarget.fromString(reader1.getString()));
                    deserializedDiskEncryptionConfiguration.targets = targets;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDiskEncryptionConfiguration;
        });
    }
}
