// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

/**
 * The disks to encrypt on each compute node.
 * 
 * If omitted, no disks on the compute nodes in the pool will be encrypted.
 */
public enum DiskEncryptionTarget {
    /**
     * Enum value OsDisk.
     */
    OS_DISK("OsDisk"),

    /**
     * Enum value TemporaryDisk.
     */
    TEMPORARY_DISK("TemporaryDisk");

    /**
     * The actual serialized value for a DiskEncryptionTarget instance.
     */
    private final String value;

    DiskEncryptionTarget(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a DiskEncryptionTarget instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed DiskEncryptionTarget object, or null if unable to parse.
     */
    public static DiskEncryptionTarget fromString(String value) {
        if (value == null) {
            return null;
        }
        DiskEncryptionTarget[] items = DiskEncryptionTarget.values();
        for (DiskEncryptionTarget item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
