// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Configures how customer data is encrypted inside the Batch account. By default, accounts are encrypted using a
 * Microsoft managed key. For additional control, a customer-managed key can be used instead.
 */
@Fluent
public final class EncryptionProperties implements JsonSerializable<EncryptionProperties> {
    /*
     * Type of the key source.
     */
    private KeySource keySource;

    /*
     * Additional details when using Microsoft.KeyVault
     */
    private KeyVaultProperties keyVaultProperties;

    /**
     * Creates an instance of EncryptionProperties class.
     */
    public EncryptionProperties() {
    }

    /**
     * Get the keySource property: Type of the key source.
     * 
     * @return the keySource value.
     */
    public KeySource keySource() {
        return this.keySource;
    }

    /**
     * Set the keySource property: Type of the key source.
     * 
     * @param keySource the keySource value to set.
     * @return the EncryptionProperties object itself.
     */
    public EncryptionProperties withKeySource(KeySource keySource) {
        this.keySource = keySource;
        return this;
    }

    /**
     * Get the keyVaultProperties property: Additional details when using Microsoft.KeyVault.
     * 
     * @return the keyVaultProperties value.
     */
    public KeyVaultProperties keyVaultProperties() {
        return this.keyVaultProperties;
    }

    /**
     * Set the keyVaultProperties property: Additional details when using Microsoft.KeyVault.
     * 
     * @param keyVaultProperties the keyVaultProperties value to set.
     * @return the EncryptionProperties object itself.
     */
    public EncryptionProperties withKeyVaultProperties(KeyVaultProperties keyVaultProperties) {
        this.keyVaultProperties = keyVaultProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (keyVaultProperties() != null) {
            keyVaultProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keySource", this.keySource == null ? null : this.keySource.toString());
        jsonWriter.writeJsonField("keyVaultProperties", this.keyVaultProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EncryptionProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EncryptionProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the EncryptionProperties.
     */
    public static EncryptionProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EncryptionProperties deserializedEncryptionProperties = new EncryptionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("keySource".equals(fieldName)) {
                    deserializedEncryptionProperties.keySource = KeySource.fromString(reader.getString());
                } else if ("keyVaultProperties".equals(fieldName)) {
                    deserializedEncryptionProperties.keyVaultProperties = KeyVaultProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEncryptionProperties;
        });
    }
}
