// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

/**
 * The default action when there is no IPRule matched.
 * 
 * Default action for endpoint access. It is only applicable when publicNetworkAccess is enabled.
 */
public enum EndpointAccessDefaultAction {
    /**
     * Enum value Allow.
     */
    ALLOW("Allow"),

    /**
     * Enum value Deny.
     */
    DENY("Deny");

    /**
     * The actual serialized value for a EndpointAccessDefaultAction instance.
     */
    private final String value;

    EndpointAccessDefaultAction(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a EndpointAccessDefaultAction instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed EndpointAccessDefaultAction object, or null if unable to parse.
     */
    public static EndpointAccessDefaultAction fromString(String value) {
        if (value == null) {
            return null;
        }
        EndpointAccessDefaultAction[] items = EndpointAccessDefaultAction.values();
        for (EndpointAccessDefaultAction item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
