// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Network access profile for Batch endpoint.
 */
@Fluent
public final class EndpointAccessProfile implements JsonSerializable<EndpointAccessProfile> {
    /*
     * Default action for endpoint access. It is only applicable when publicNetworkAccess is enabled.
     */
    private EndpointAccessDefaultAction defaultAction;

    /*
     * Array of IP ranges to filter client IP address.
     */
    private List<IpRule> ipRules;

    /**
     * Creates an instance of EndpointAccessProfile class.
     */
    public EndpointAccessProfile() {
    }

    /**
     * Get the defaultAction property: Default action for endpoint access. It is only applicable when
     * publicNetworkAccess is enabled.
     * 
     * @return the defaultAction value.
     */
    public EndpointAccessDefaultAction defaultAction() {
        return this.defaultAction;
    }

    /**
     * Set the defaultAction property: Default action for endpoint access. It is only applicable when
     * publicNetworkAccess is enabled.
     * 
     * @param defaultAction the defaultAction value to set.
     * @return the EndpointAccessProfile object itself.
     */
    public EndpointAccessProfile withDefaultAction(EndpointAccessDefaultAction defaultAction) {
        this.defaultAction = defaultAction;
        return this;
    }

    /**
     * Get the ipRules property: Array of IP ranges to filter client IP address.
     * 
     * @return the ipRules value.
     */
    public List<IpRule> ipRules() {
        return this.ipRules;
    }

    /**
     * Set the ipRules property: Array of IP ranges to filter client IP address.
     * 
     * @param ipRules the ipRules value to set.
     * @return the EndpointAccessProfile object itself.
     */
    public EndpointAccessProfile withIpRules(List<IpRule> ipRules) {
        this.ipRules = ipRules;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (defaultAction() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property defaultAction in model EndpointAccessProfile"));
        }
        if (ipRules() != null) {
            ipRules().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(EndpointAccessProfile.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("defaultAction", this.defaultAction == null ? null : this.defaultAction.toString());
        jsonWriter.writeArrayField("ipRules", this.ipRules, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EndpointAccessProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EndpointAccessProfile if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the EndpointAccessProfile.
     */
    public static EndpointAccessProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EndpointAccessProfile deserializedEndpointAccessProfile = new EndpointAccessProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("defaultAction".equals(fieldName)) {
                    deserializedEndpointAccessProfile.defaultAction
                        = EndpointAccessDefaultAction.fromString(reader.getString());
                } else if ("ipRules".equals(fieldName)) {
                    List<IpRule> ipRules = reader.readArray(reader1 -> IpRule.fromJson(reader1));
                    deserializedEndpointAccessProfile.ipRules = ipRules;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEndpointAccessProfile;
        });
    }
}
