// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * An environment variable to be set on a task process.
 */
@Fluent
public final class EnvironmentSetting implements JsonSerializable<EnvironmentSetting> {
    /*
     * The name of the environment variable.
     */
    private String name;

    /*
     * The value of the environment variable.
     */
    private String value;

    /**
     * Creates an instance of EnvironmentSetting class.
     */
    public EnvironmentSetting() {
    }

    /**
     * Get the name property: The name of the environment variable.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the environment variable.
     * 
     * @param name the name value to set.
     * @return the EnvironmentSetting object itself.
     */
    public EnvironmentSetting withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the value property: The value of the environment variable.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: The value of the environment variable.
     * 
     * @param value the value value to set.
     * @return the EnvironmentSetting object itself.
     */
    public EnvironmentSetting withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property name in model EnvironmentSetting"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(EnvironmentSetting.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EnvironmentSetting from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EnvironmentSetting if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the EnvironmentSetting.
     */
    public static EnvironmentSetting fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EnvironmentSetting deserializedEnvironmentSetting = new EnvironmentSetting();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedEnvironmentSetting.name = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedEnvironmentSetting.value = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEnvironmentSetting;
        });
    }
}
