// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;

/**
 * Fixed scale settings for the pool.
 */
@Fluent
public final class FixedScaleSettings implements JsonSerializable<FixedScaleSettings> {
    /*
     * The default value is 15 minutes. Timeout values use ISO 8601 format. For example, use PT10M for 10 minutes. The
     * minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch service rejects the request
     * with an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
     */
    private Duration resizeTimeout;

    /*
     * At least one of targetDedicatedNodes, targetLowPriorityNodes must be set.
     */
    private Integer targetDedicatedNodes;

    /*
     * At least one of targetDedicatedNodes, targetLowPriorityNodes must be set.
     */
    private Integer targetLowPriorityNodes;

    /*
     * If omitted, the default value is Requeue.
     */
    private ComputeNodeDeallocationOption nodeDeallocationOption;

    /**
     * Creates an instance of FixedScaleSettings class.
     */
    public FixedScaleSettings() {
    }

    /**
     * Get the resizeTimeout property: The default value is 15 minutes. Timeout values use ISO 8601 format. For example,
     * use PT10M for 10 minutes. The minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch
     * service rejects the request with an error; if you are calling the REST API directly, the HTTP status code is 400
     * (Bad Request).
     * 
     * @return the resizeTimeout value.
     */
    public Duration resizeTimeout() {
        return this.resizeTimeout;
    }

    /**
     * Set the resizeTimeout property: The default value is 15 minutes. Timeout values use ISO 8601 format. For example,
     * use PT10M for 10 minutes. The minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch
     * service rejects the request with an error; if you are calling the REST API directly, the HTTP status code is 400
     * (Bad Request).
     * 
     * @param resizeTimeout the resizeTimeout value to set.
     * @return the FixedScaleSettings object itself.
     */
    public FixedScaleSettings withResizeTimeout(Duration resizeTimeout) {
        this.resizeTimeout = resizeTimeout;
        return this;
    }

    /**
     * Get the targetDedicatedNodes property: At least one of targetDedicatedNodes, targetLowPriorityNodes must be set.
     * 
     * @return the targetDedicatedNodes value.
     */
    public Integer targetDedicatedNodes() {
        return this.targetDedicatedNodes;
    }

    /**
     * Set the targetDedicatedNodes property: At least one of targetDedicatedNodes, targetLowPriorityNodes must be set.
     * 
     * @param targetDedicatedNodes the targetDedicatedNodes value to set.
     * @return the FixedScaleSettings object itself.
     */
    public FixedScaleSettings withTargetDedicatedNodes(Integer targetDedicatedNodes) {
        this.targetDedicatedNodes = targetDedicatedNodes;
        return this;
    }

    /**
     * Get the targetLowPriorityNodes property: At least one of targetDedicatedNodes, targetLowPriorityNodes must be
     * set.
     * 
     * @return the targetLowPriorityNodes value.
     */
    public Integer targetLowPriorityNodes() {
        return this.targetLowPriorityNodes;
    }

    /**
     * Set the targetLowPriorityNodes property: At least one of targetDedicatedNodes, targetLowPriorityNodes must be
     * set.
     * 
     * @param targetLowPriorityNodes the targetLowPriorityNodes value to set.
     * @return the FixedScaleSettings object itself.
     */
    public FixedScaleSettings withTargetLowPriorityNodes(Integer targetLowPriorityNodes) {
        this.targetLowPriorityNodes = targetLowPriorityNodes;
        return this;
    }

    /**
     * Get the nodeDeallocationOption property: If omitted, the default value is Requeue.
     * 
     * @return the nodeDeallocationOption value.
     */
    public ComputeNodeDeallocationOption nodeDeallocationOption() {
        return this.nodeDeallocationOption;
    }

    /**
     * Set the nodeDeallocationOption property: If omitted, the default value is Requeue.
     * 
     * @param nodeDeallocationOption the nodeDeallocationOption value to set.
     * @return the FixedScaleSettings object itself.
     */
    public FixedScaleSettings withNodeDeallocationOption(ComputeNodeDeallocationOption nodeDeallocationOption) {
        this.nodeDeallocationOption = nodeDeallocationOption;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resizeTimeout", CoreUtils.durationToStringWithDays(this.resizeTimeout));
        jsonWriter.writeNumberField("targetDedicatedNodes", this.targetDedicatedNodes);
        jsonWriter.writeNumberField("targetLowPriorityNodes", this.targetLowPriorityNodes);
        jsonWriter.writeStringField("nodeDeallocationOption",
            this.nodeDeallocationOption == null ? null : this.nodeDeallocationOption.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FixedScaleSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FixedScaleSettings if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the FixedScaleSettings.
     */
    public static FixedScaleSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FixedScaleSettings deserializedFixedScaleSettings = new FixedScaleSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("resizeTimeout".equals(fieldName)) {
                    deserializedFixedScaleSettings.resizeTimeout
                        = reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                } else if ("targetDedicatedNodes".equals(fieldName)) {
                    deserializedFixedScaleSettings.targetDedicatedNodes = reader.getNullable(JsonReader::getInt);
                } else if ("targetLowPriorityNodes".equals(fieldName)) {
                    deserializedFixedScaleSettings.targetLowPriorityNodes = reader.getNullable(JsonReader::getInt);
                } else if ("nodeDeallocationOption".equals(fieldName)) {
                    deserializedFixedScaleSettings.nodeDeallocationOption
                        = ComputeNodeDeallocationOption.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFixedScaleSettings;
        });
    }
}
