// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

/**
 * The provisioning type for Public IP Addresses for the Batch Pool.
 */
public enum IpAddressProvisioningType {
    /**
     * Enum value BatchManaged.
     */
    BATCH_MANAGED("BatchManaged"),

    /**
     * Enum value UserManaged.
     */
    USER_MANAGED("UserManaged"),

    /**
     * Enum value NoPublicIPAddresses.
     */
    NO_PUBLIC_IPADDRESSES("NoPublicIPAddresses");

    /**
     * The actual serialized value for a IpAddressProvisioningType instance.
     */
    private final String value;

    IpAddressProvisioningType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a IpAddressProvisioningType instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed IpAddressProvisioningType object, or null if unable to parse.
     */
    public static IpAddressProvisioningType fromString(String value) {
        if (value == null) {
            return null;
        }
        IpAddressProvisioningType[] items = IpAddressProvisioningType.values();
        for (IpAddressProvisioningType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
