// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.fluent.models.PoolInner;
import java.io.IOException;
import java.util.List;

/**
 * Values returned by the List operation.
 */
@Fluent
public final class ListPoolsResult implements JsonSerializable<ListPoolsResult> {
    /*
     * The collection of returned pools.
     */
    private List<PoolInner> value;

    /*
     * The continuation token.
     */
    private String nextLink;

    /**
     * Creates an instance of ListPoolsResult class.
     */
    public ListPoolsResult() {
    }

    /**
     * Get the value property: The collection of returned pools.
     * 
     * @return the value value.
     */
    public List<PoolInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The collection of returned pools.
     * 
     * @param value the value value to set.
     * @return the ListPoolsResult object itself.
     */
    public ListPoolsResult withValue(List<PoolInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The continuation token.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The continuation token.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ListPoolsResult object itself.
     */
    public ListPoolsResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ListPoolsResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ListPoolsResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ListPoolsResult.
     */
    public static ListPoolsResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ListPoolsResult deserializedListPoolsResult = new ListPoolsResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<PoolInner> value = reader.readArray(reader1 -> PoolInner.fromJson(reader1));
                    deserializedListPoolsResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedListPoolsResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedListPoolsResult;
        });
    }
}
