// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.batch.fluent.models.PrivateEndpointConnectionInner;
import java.io.IOException;
import java.util.List;

/**
 * Values returned by the List operation.
 */
@Fluent
public final class ListPrivateEndpointConnectionsResult
    implements JsonSerializable<ListPrivateEndpointConnectionsResult> {
    /*
     * The collection of returned private endpoint connection.
     */
    private List<PrivateEndpointConnectionInner> value;

    /*
     * The continuation token.
     */
    private String nextLink;

    /**
     * Creates an instance of ListPrivateEndpointConnectionsResult class.
     */
    public ListPrivateEndpointConnectionsResult() {
    }

    /**
     * Get the value property: The collection of returned private endpoint connection.
     * 
     * @return the value value.
     */
    public List<PrivateEndpointConnectionInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The collection of returned private endpoint connection.
     * 
     * @param value the value value to set.
     * @return the ListPrivateEndpointConnectionsResult object itself.
     */
    public ListPrivateEndpointConnectionsResult withValue(List<PrivateEndpointConnectionInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The continuation token.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The continuation token.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ListPrivateEndpointConnectionsResult object itself.
     */
    public ListPrivateEndpointConnectionsResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ListPrivateEndpointConnectionsResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ListPrivateEndpointConnectionsResult if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ListPrivateEndpointConnectionsResult.
     */
    public static ListPrivateEndpointConnectionsResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ListPrivateEndpointConnectionsResult deserializedListPrivateEndpointConnectionsResult
                = new ListPrivateEndpointConnectionsResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<PrivateEndpointConnectionInner> value
                        = reader.readArray(reader1 -> PrivateEndpointConnectionInner.fromJson(reader1));
                    deserializedListPrivateEndpointConnectionsResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedListPrivateEndpointConnectionsResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedListPrivateEndpointConnectionsResult;
        });
    }
}
