// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

/**
 * Login mode for user
 * 
 * Specifies login mode for the user. The default value is Interactive.
 */
public enum LoginMode {
    /**
     * Enum value Batch.
     */
    BATCH("Batch"),

    /**
     * Enum value Interactive.
     */
    INTERACTIVE("Interactive");

    /**
     * The actual serialized value for a LoginMode instance.
     */
    private final String value;

    LoginMode(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a LoginMode instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed LoginMode object, or null if unable to parse.
     */
    public static LoginMode fromString(String value) {
        if (value == null) {
            return null;
        }
        LoginMode[] items = LoginMode.values();
        for (LoginMode item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
