// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A name-value pair associated with a Batch service resource.
 * 
 * The Batch service does not assign any meaning to this metadata; it is solely for the use of user code.
 */
@Fluent
public final class MetadataItem implements JsonSerializable<MetadataItem> {
    /*
     * The name of the metadata item.
     */
    private String name;

    /*
     * The value of the metadata item.
     */
    private String value;

    /**
     * Creates an instance of MetadataItem class.
     */
    public MetadataItem() {
    }

    /**
     * Get the name property: The name of the metadata item.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the metadata item.
     * 
     * @param name the name value to set.
     * @return the MetadataItem object itself.
     */
    public MetadataItem withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the value property: The value of the metadata item.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: The value of the metadata item.
     * 
     * @param value the value value to set.
     * @return the MetadataItem object itself.
     */
    public MetadataItem withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property name in model MetadataItem"));
        }
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property value in model MetadataItem"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(MetadataItem.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MetadataItem from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MetadataItem if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MetadataItem.
     */
    public static MetadataItem fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MetadataItem deserializedMetadataItem = new MetadataItem();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedMetadataItem.name = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedMetadataItem.value = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMetadataItem;
        });
    }
}
