// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The file system to mount on each node.
 */
@Fluent
public final class MountConfiguration implements JsonSerializable<MountConfiguration> {
    /*
     * This property is mutually exclusive with all other properties.
     */
    private AzureBlobFileSystemConfiguration azureBlobFileSystemConfiguration;

    /*
     * This property is mutually exclusive with all other properties.
     */
    private NfsMountConfiguration nfsMountConfiguration;

    /*
     * This property is mutually exclusive with all other properties.
     */
    private CifsMountConfiguration cifsMountConfiguration;

    /*
     * This property is mutually exclusive with all other properties.
     */
    private AzureFileShareConfiguration azureFileShareConfiguration;

    /**
     * Creates an instance of MountConfiguration class.
     */
    public MountConfiguration() {
    }

    /**
     * Get the azureBlobFileSystemConfiguration property: This property is mutually exclusive with all other properties.
     * 
     * @return the azureBlobFileSystemConfiguration value.
     */
    public AzureBlobFileSystemConfiguration azureBlobFileSystemConfiguration() {
        return this.azureBlobFileSystemConfiguration;
    }

    /**
     * Set the azureBlobFileSystemConfiguration property: This property is mutually exclusive with all other properties.
     * 
     * @param azureBlobFileSystemConfiguration the azureBlobFileSystemConfiguration value to set.
     * @return the MountConfiguration object itself.
     */
    public MountConfiguration
        withAzureBlobFileSystemConfiguration(AzureBlobFileSystemConfiguration azureBlobFileSystemConfiguration) {
        this.azureBlobFileSystemConfiguration = azureBlobFileSystemConfiguration;
        return this;
    }

    /**
     * Get the nfsMountConfiguration property: This property is mutually exclusive with all other properties.
     * 
     * @return the nfsMountConfiguration value.
     */
    public NfsMountConfiguration nfsMountConfiguration() {
        return this.nfsMountConfiguration;
    }

    /**
     * Set the nfsMountConfiguration property: This property is mutually exclusive with all other properties.
     * 
     * @param nfsMountConfiguration the nfsMountConfiguration value to set.
     * @return the MountConfiguration object itself.
     */
    public MountConfiguration withNfsMountConfiguration(NfsMountConfiguration nfsMountConfiguration) {
        this.nfsMountConfiguration = nfsMountConfiguration;
        return this;
    }

    /**
     * Get the cifsMountConfiguration property: This property is mutually exclusive with all other properties.
     * 
     * @return the cifsMountConfiguration value.
     */
    public CifsMountConfiguration cifsMountConfiguration() {
        return this.cifsMountConfiguration;
    }

    /**
     * Set the cifsMountConfiguration property: This property is mutually exclusive with all other properties.
     * 
     * @param cifsMountConfiguration the cifsMountConfiguration value to set.
     * @return the MountConfiguration object itself.
     */
    public MountConfiguration withCifsMountConfiguration(CifsMountConfiguration cifsMountConfiguration) {
        this.cifsMountConfiguration = cifsMountConfiguration;
        return this;
    }

    /**
     * Get the azureFileShareConfiguration property: This property is mutually exclusive with all other properties.
     * 
     * @return the azureFileShareConfiguration value.
     */
    public AzureFileShareConfiguration azureFileShareConfiguration() {
        return this.azureFileShareConfiguration;
    }

    /**
     * Set the azureFileShareConfiguration property: This property is mutually exclusive with all other properties.
     * 
     * @param azureFileShareConfiguration the azureFileShareConfiguration value to set.
     * @return the MountConfiguration object itself.
     */
    public MountConfiguration withAzureFileShareConfiguration(AzureFileShareConfiguration azureFileShareConfiguration) {
        this.azureFileShareConfiguration = azureFileShareConfiguration;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (azureBlobFileSystemConfiguration() != null) {
            azureBlobFileSystemConfiguration().validate();
        }
        if (nfsMountConfiguration() != null) {
            nfsMountConfiguration().validate();
        }
        if (cifsMountConfiguration() != null) {
            cifsMountConfiguration().validate();
        }
        if (azureFileShareConfiguration() != null) {
            azureFileShareConfiguration().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("azureBlobFileSystemConfiguration", this.azureBlobFileSystemConfiguration);
        jsonWriter.writeJsonField("nfsMountConfiguration", this.nfsMountConfiguration);
        jsonWriter.writeJsonField("cifsMountConfiguration", this.cifsMountConfiguration);
        jsonWriter.writeJsonField("azureFileShareConfiguration", this.azureFileShareConfiguration);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MountConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MountConfiguration if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the MountConfiguration.
     */
    public static MountConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MountConfiguration deserializedMountConfiguration = new MountConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("azureBlobFileSystemConfiguration".equals(fieldName)) {
                    deserializedMountConfiguration.azureBlobFileSystemConfiguration
                        = AzureBlobFileSystemConfiguration.fromJson(reader);
                } else if ("nfsMountConfiguration".equals(fieldName)) {
                    deserializedMountConfiguration.nfsMountConfiguration = NfsMountConfiguration.fromJson(reader);
                } else if ("cifsMountConfiguration".equals(fieldName)) {
                    deserializedMountConfiguration.cifsMountConfiguration = CifsMountConfiguration.fromJson(reader);
                } else if ("azureFileShareConfiguration".equals(fieldName)) {
                    deserializedMountConfiguration.azureFileShareConfiguration
                        = AzureFileShareConfiguration.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMountConfiguration;
        });
    }
}
