// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The network configuration for a pool.
 */
@Fluent
public final class NetworkConfiguration implements JsonSerializable<NetworkConfiguration> {
    /*
     * The virtual network must be in the same region and subscription as the Azure Batch account. The specified subnet
     * should have enough free IP addresses to accommodate the number of nodes in the pool. If the subnet doesn't have
     * enough free IP addresses, the pool will partially allocate compute nodes and a resize error will occur. The
     * 'MicrosoftAzureBatch' service principal must have the 'Classic Virtual Machine Contributor' Role-Based Access
     * Control (RBAC) role for the specified VNet. The specified subnet must allow communication from the Azure Batch
     * service to be able to schedule tasks on the compute nodes. This can be verified by checking if the specified VNet
     * has any associated Network Security Groups (NSG). If communication to the compute nodes in the specified subnet
     * is denied by an NSG, then the Batch service will set the state of the compute nodes to unusable. If the specified
     * VNet has any associated Network Security Groups (NSG), then a few reserved system ports must be enabled for
     * inbound communication. Enable ports 29876 and 29877, as well as port 22 for Linux and port 3389 for Windows. Also
     * enable outbound connections to Azure Storage on port 443. For more details see:
     * https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration
     */
    private String subnetId;

    /*
     * The scope of dynamic vnet assignment.
     */
    private DynamicVNetAssignmentScope dynamicVnetAssignmentScope;

    /*
     * The endpoint configuration for a pool.
     */
    private PoolEndpointConfiguration endpointConfiguration;

    /*
     * The public IP Address configuration of the networking configuration of a Pool.
     */
    private PublicIpAddressConfiguration publicIpAddressConfiguration;

    /*
     * Accelerated networking enables single root I/O virtualization (SR-IOV) to a VM, which may lead to improved
     * networking performance. For more details, see:
     * https://learn.microsoft.com/azure/virtual-network/accelerated-networking-overview.
     */
    private Boolean enableAcceleratedNetworking;

    /**
     * Creates an instance of NetworkConfiguration class.
     */
    public NetworkConfiguration() {
    }

    /**
     * Get the subnetId property: The virtual network must be in the same region and subscription as the Azure Batch
     * account. The specified subnet should have enough free IP addresses to accommodate the number of nodes in the
     * pool. If the subnet doesn't have enough free IP addresses, the pool will partially allocate compute nodes and a
     * resize error will occur. The 'MicrosoftAzureBatch' service principal must have the 'Classic Virtual Machine
     * Contributor' Role-Based Access Control (RBAC) role for the specified VNet. The specified subnet must allow
     * communication from the Azure Batch service to be able to schedule tasks on the compute nodes. This can be
     * verified by checking if the specified VNet has any associated Network Security Groups (NSG). If communication to
     * the compute nodes in the specified subnet is denied by an NSG, then the Batch service will set the state of the
     * compute nodes to unusable. If the specified VNet has any associated Network Security Groups (NSG), then a few
     * reserved system ports must be enabled for inbound communication. Enable ports 29876 and 29877, as well as port 22
     * for Linux and port 3389 for Windows. Also enable outbound connections to Azure Storage on port 443. For more
     * details see:
     * https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
     * 
     * @return the subnetId value.
     */
    public String subnetId() {
        return this.subnetId;
    }

    /**
     * Set the subnetId property: The virtual network must be in the same region and subscription as the Azure Batch
     * account. The specified subnet should have enough free IP addresses to accommodate the number of nodes in the
     * pool. If the subnet doesn't have enough free IP addresses, the pool will partially allocate compute nodes and a
     * resize error will occur. The 'MicrosoftAzureBatch' service principal must have the 'Classic Virtual Machine
     * Contributor' Role-Based Access Control (RBAC) role for the specified VNet. The specified subnet must allow
     * communication from the Azure Batch service to be able to schedule tasks on the compute nodes. This can be
     * verified by checking if the specified VNet has any associated Network Security Groups (NSG). If communication to
     * the compute nodes in the specified subnet is denied by an NSG, then the Batch service will set the state of the
     * compute nodes to unusable. If the specified VNet has any associated Network Security Groups (NSG), then a few
     * reserved system ports must be enabled for inbound communication. Enable ports 29876 and 29877, as well as port 22
     * for Linux and port 3389 for Windows. Also enable outbound connections to Azure Storage on port 443. For more
     * details see:
     * https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
     * 
     * @param subnetId the subnetId value to set.
     * @return the NetworkConfiguration object itself.
     */
    public NetworkConfiguration withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    /**
     * Get the dynamicVnetAssignmentScope property: The scope of dynamic vnet assignment.
     * 
     * @return the dynamicVnetAssignmentScope value.
     */
    public DynamicVNetAssignmentScope dynamicVnetAssignmentScope() {
        return this.dynamicVnetAssignmentScope;
    }

    /**
     * Set the dynamicVnetAssignmentScope property: The scope of dynamic vnet assignment.
     * 
     * @param dynamicVnetAssignmentScope the dynamicVnetAssignmentScope value to set.
     * @return the NetworkConfiguration object itself.
     */
    public NetworkConfiguration withDynamicVnetAssignmentScope(DynamicVNetAssignmentScope dynamicVnetAssignmentScope) {
        this.dynamicVnetAssignmentScope = dynamicVnetAssignmentScope;
        return this;
    }

    /**
     * Get the endpointConfiguration property: The endpoint configuration for a pool.
     * 
     * @return the endpointConfiguration value.
     */
    public PoolEndpointConfiguration endpointConfiguration() {
        return this.endpointConfiguration;
    }

    /**
     * Set the endpointConfiguration property: The endpoint configuration for a pool.
     * 
     * @param endpointConfiguration the endpointConfiguration value to set.
     * @return the NetworkConfiguration object itself.
     */
    public NetworkConfiguration withEndpointConfiguration(PoolEndpointConfiguration endpointConfiguration) {
        this.endpointConfiguration = endpointConfiguration;
        return this;
    }

    /**
     * Get the publicIpAddressConfiguration property: The public IP Address configuration of the networking
     * configuration of a Pool.
     * 
     * @return the publicIpAddressConfiguration value.
     */
    public PublicIpAddressConfiguration publicIpAddressConfiguration() {
        return this.publicIpAddressConfiguration;
    }

    /**
     * Set the publicIpAddressConfiguration property: The public IP Address configuration of the networking
     * configuration of a Pool.
     * 
     * @param publicIpAddressConfiguration the publicIpAddressConfiguration value to set.
     * @return the NetworkConfiguration object itself.
     */
    public NetworkConfiguration
        withPublicIpAddressConfiguration(PublicIpAddressConfiguration publicIpAddressConfiguration) {
        this.publicIpAddressConfiguration = publicIpAddressConfiguration;
        return this;
    }

    /**
     * Get the enableAcceleratedNetworking property: Accelerated networking enables single root I/O virtualization
     * (SR-IOV) to a VM, which may lead to improved networking performance. For more details, see:
     * https://learn.microsoft.com/azure/virtual-network/accelerated-networking-overview.
     * 
     * @return the enableAcceleratedNetworking value.
     */
    public Boolean enableAcceleratedNetworking() {
        return this.enableAcceleratedNetworking;
    }

    /**
     * Set the enableAcceleratedNetworking property: Accelerated networking enables single root I/O virtualization
     * (SR-IOV) to a VM, which may lead to improved networking performance. For more details, see:
     * https://learn.microsoft.com/azure/virtual-network/accelerated-networking-overview.
     * 
     * @param enableAcceleratedNetworking the enableAcceleratedNetworking value to set.
     * @return the NetworkConfiguration object itself.
     */
    public NetworkConfiguration withEnableAcceleratedNetworking(Boolean enableAcceleratedNetworking) {
        this.enableAcceleratedNetworking = enableAcceleratedNetworking;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (endpointConfiguration() != null) {
            endpointConfiguration().validate();
        }
        if (publicIpAddressConfiguration() != null) {
            publicIpAddressConfiguration().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("subnetId", this.subnetId);
        jsonWriter.writeStringField("dynamicVnetAssignmentScope",
            this.dynamicVnetAssignmentScope == null ? null : this.dynamicVnetAssignmentScope.toString());
        jsonWriter.writeJsonField("endpointConfiguration", this.endpointConfiguration);
        jsonWriter.writeJsonField("publicIPAddressConfiguration", this.publicIpAddressConfiguration);
        jsonWriter.writeBooleanField("enableAcceleratedNetworking", this.enableAcceleratedNetworking);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkConfiguration if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NetworkConfiguration.
     */
    public static NetworkConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkConfiguration deserializedNetworkConfiguration = new NetworkConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("subnetId".equals(fieldName)) {
                    deserializedNetworkConfiguration.subnetId = reader.getString();
                } else if ("dynamicVnetAssignmentScope".equals(fieldName)) {
                    deserializedNetworkConfiguration.dynamicVnetAssignmentScope
                        = DynamicVNetAssignmentScope.fromString(reader.getString());
                } else if ("endpointConfiguration".equals(fieldName)) {
                    deserializedNetworkConfiguration.endpointConfiguration = PoolEndpointConfiguration.fromJson(reader);
                } else if ("publicIPAddressConfiguration".equals(fieldName)) {
                    deserializedNetworkConfiguration.publicIpAddressConfiguration
                        = PublicIpAddressConfiguration.fromJson(reader);
                } else if ("enableAcceleratedNetworking".equals(fieldName)) {
                    deserializedNetworkConfiguration.enableAcceleratedNetworking
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkConfiguration;
        });
    }
}
