// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Network profile for Batch account, which contains network rule settings for each endpoint.
 */
@Fluent
public final class NetworkProfile implements JsonSerializable<NetworkProfile> {
    /*
     * Network access profile for batchAccount endpoint (Batch account data plane API).
     */
    private EndpointAccessProfile accountAccess;

    /*
     * Network access profile for nodeManagement endpoint (Batch service managing compute nodes for Batch pools).
     */
    private EndpointAccessProfile nodeManagementAccess;

    /**
     * Creates an instance of NetworkProfile class.
     */
    public NetworkProfile() {
    }

    /**
     * Get the accountAccess property: Network access profile for batchAccount endpoint (Batch account data plane API).
     * 
     * @return the accountAccess value.
     */
    public EndpointAccessProfile accountAccess() {
        return this.accountAccess;
    }

    /**
     * Set the accountAccess property: Network access profile for batchAccount endpoint (Batch account data plane API).
     * 
     * @param accountAccess the accountAccess value to set.
     * @return the NetworkProfile object itself.
     */
    public NetworkProfile withAccountAccess(EndpointAccessProfile accountAccess) {
        this.accountAccess = accountAccess;
        return this;
    }

    /**
     * Get the nodeManagementAccess property: Network access profile for nodeManagement endpoint (Batch service managing
     * compute nodes for Batch pools).
     * 
     * @return the nodeManagementAccess value.
     */
    public EndpointAccessProfile nodeManagementAccess() {
        return this.nodeManagementAccess;
    }

    /**
     * Set the nodeManagementAccess property: Network access profile for nodeManagement endpoint (Batch service managing
     * compute nodes for Batch pools).
     * 
     * @param nodeManagementAccess the nodeManagementAccess value to set.
     * @return the NetworkProfile object itself.
     */
    public NetworkProfile withNodeManagementAccess(EndpointAccessProfile nodeManagementAccess) {
        this.nodeManagementAccess = nodeManagementAccess;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (accountAccess() != null) {
            accountAccess().validate();
        }
        if (nodeManagementAccess() != null) {
            nodeManagementAccess().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("accountAccess", this.accountAccess);
        jsonWriter.writeJsonField("nodeManagementAccess", this.nodeManagementAccess);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkProfile if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the NetworkProfile.
     */
    public static NetworkProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkProfile deserializedNetworkProfile = new NetworkProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("accountAccess".equals(fieldName)) {
                    deserializedNetworkProfile.accountAccess = EndpointAccessProfile.fromJson(reader);
                } else if ("nodeManagementAccess".equals(fieldName)) {
                    deserializedNetworkProfile.nodeManagementAccess = EndpointAccessProfile.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkProfile;
        });
    }
}
