// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

/**
 * The action that should be taken for a specified IP address, subnet range or tag.
 */
public enum NetworkSecurityGroupRuleAccess {
    /**
     * Enum value Allow.
     */
    ALLOW("Allow"),

    /**
     * Enum value Deny.
     */
    DENY("Deny");

    /**
     * The actual serialized value for a NetworkSecurityGroupRuleAccess instance.
     */
    private final String value;

    NetworkSecurityGroupRuleAccess(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a NetworkSecurityGroupRuleAccess instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed NetworkSecurityGroupRuleAccess object, or null if unable to parse.
     */
    public static NetworkSecurityGroupRuleAccess fromString(String value) {
        if (value == null) {
            return null;
        }
        NetworkSecurityGroupRuleAccess[] items = NetworkSecurityGroupRuleAccess.values();
        for (NetworkSecurityGroupRuleAccess item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
