// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.management.SystemData;
import com.azure.resourcemanager.batch.fluent.models.NetworkSecurityPerimeterConfigurationInner;

/**
 * An immutable client-side representation of NetworkSecurityPerimeterConfiguration.
 */
public interface NetworkSecurityPerimeterConfiguration {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the properties property: Network security configuration properties.
     * 
     * @return the properties value.
     */
    NetworkSecurityPerimeterConfigurationProperties properties();

    /**
     * Gets the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    SystemData systemData();

    /**
     * Gets the inner com.azure.resourcemanager.batch.fluent.models.NetworkSecurityPerimeterConfigurationInner object.
     * 
     * @return the inner object.
     */
    NetworkSecurityPerimeterConfigurationInner innerModel();
}
