// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Network security perimeter configuration profile.
 */
@Fluent
public final class NetworkSecurityProfile implements JsonSerializable<NetworkSecurityProfile> {
    /*
     * Name of the profile
     */
    private String name;

    /*
     * Current access rules version
     */
    private Integer accessRulesVersion;

    /*
     * List of Access Rules
     */
    private List<AccessRule> accessRules;

    /*
     * Current diagnostic settings version
     */
    private Integer diagnosticSettingsVersion;

    /*
     * List of log categories that are enabled
     */
    private List<String> enabledLogCategories;

    /**
     * Creates an instance of NetworkSecurityProfile class.
     */
    public NetworkSecurityProfile() {
    }

    /**
     * Get the name property: Name of the profile.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the profile.
     * 
     * @param name the name value to set.
     * @return the NetworkSecurityProfile object itself.
     */
    public NetworkSecurityProfile withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the accessRulesVersion property: Current access rules version.
     * 
     * @return the accessRulesVersion value.
     */
    public Integer accessRulesVersion() {
        return this.accessRulesVersion;
    }

    /**
     * Set the accessRulesVersion property: Current access rules version.
     * 
     * @param accessRulesVersion the accessRulesVersion value to set.
     * @return the NetworkSecurityProfile object itself.
     */
    public NetworkSecurityProfile withAccessRulesVersion(Integer accessRulesVersion) {
        this.accessRulesVersion = accessRulesVersion;
        return this;
    }

    /**
     * Get the accessRules property: List of Access Rules.
     * 
     * @return the accessRules value.
     */
    public List<AccessRule> accessRules() {
        return this.accessRules;
    }

    /**
     * Set the accessRules property: List of Access Rules.
     * 
     * @param accessRules the accessRules value to set.
     * @return the NetworkSecurityProfile object itself.
     */
    public NetworkSecurityProfile withAccessRules(List<AccessRule> accessRules) {
        this.accessRules = accessRules;
        return this;
    }

    /**
     * Get the diagnosticSettingsVersion property: Current diagnostic settings version.
     * 
     * @return the diagnosticSettingsVersion value.
     */
    public Integer diagnosticSettingsVersion() {
        return this.diagnosticSettingsVersion;
    }

    /**
     * Set the diagnosticSettingsVersion property: Current diagnostic settings version.
     * 
     * @param diagnosticSettingsVersion the diagnosticSettingsVersion value to set.
     * @return the NetworkSecurityProfile object itself.
     */
    public NetworkSecurityProfile withDiagnosticSettingsVersion(Integer diagnosticSettingsVersion) {
        this.diagnosticSettingsVersion = diagnosticSettingsVersion;
        return this;
    }

    /**
     * Get the enabledLogCategories property: List of log categories that are enabled.
     * 
     * @return the enabledLogCategories value.
     */
    public List<String> enabledLogCategories() {
        return this.enabledLogCategories;
    }

    /**
     * Set the enabledLogCategories property: List of log categories that are enabled.
     * 
     * @param enabledLogCategories the enabledLogCategories value to set.
     * @return the NetworkSecurityProfile object itself.
     */
    public NetworkSecurityProfile withEnabledLogCategories(List<String> enabledLogCategories) {
        this.enabledLogCategories = enabledLogCategories;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (accessRules() != null) {
            accessRules().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeNumberField("accessRulesVersion", this.accessRulesVersion);
        jsonWriter.writeArrayField("accessRules", this.accessRules, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeNumberField("diagnosticSettingsVersion", this.diagnosticSettingsVersion);
        jsonWriter.writeArrayField("enabledLogCategories", this.enabledLogCategories,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkSecurityProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkSecurityProfile if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NetworkSecurityProfile.
     */
    public static NetworkSecurityProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkSecurityProfile deserializedNetworkSecurityProfile = new NetworkSecurityProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedNetworkSecurityProfile.name = reader.getString();
                } else if ("accessRulesVersion".equals(fieldName)) {
                    deserializedNetworkSecurityProfile.accessRulesVersion = reader.getNullable(JsonReader::getInt);
                } else if ("accessRules".equals(fieldName)) {
                    List<AccessRule> accessRules = reader.readArray(reader1 -> AccessRule.fromJson(reader1));
                    deserializedNetworkSecurityProfile.accessRules = accessRules;
                } else if ("diagnosticSettingsVersion".equals(fieldName)) {
                    deserializedNetworkSecurityProfile.diagnosticSettingsVersion
                        = reader.getNullable(JsonReader::getInt);
                } else if ("enabledLogCategories".equals(fieldName)) {
                    List<String> enabledLogCategories = reader.readArray(reader1 -> reader1.getString());
                    deserializedNetworkSecurityProfile.enabledLogCategories = enabledLogCategories;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkSecurityProfile;
        });
    }
}
