// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Information used to connect to an NFS file system.
 */
@Fluent
public final class NfsMountConfiguration implements JsonSerializable<NfsMountConfiguration> {
    /*
     * The URI of the file system to mount.
     */
    private String source;

    /*
     * All file systems are mounted relative to the Batch mounts directory, accessible via the AZ_BATCH_NODE_MOUNTS_DIR
     * environment variable.
     */
    private String relativeMountPath;

    /*
     * These are 'net use' options in Windows and 'mount' options in Linux.
     */
    private String mountOptions;

    /**
     * Creates an instance of NfsMountConfiguration class.
     */
    public NfsMountConfiguration() {
    }

    /**
     * Get the source property: The URI of the file system to mount.
     * 
     * @return the source value.
     */
    public String source() {
        return this.source;
    }

    /**
     * Set the source property: The URI of the file system to mount.
     * 
     * @param source the source value to set.
     * @return the NfsMountConfiguration object itself.
     */
    public NfsMountConfiguration withSource(String source) {
        this.source = source;
        return this;
    }

    /**
     * Get the relativeMountPath property: All file systems are mounted relative to the Batch mounts directory,
     * accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
     * 
     * @return the relativeMountPath value.
     */
    public String relativeMountPath() {
        return this.relativeMountPath;
    }

    /**
     * Set the relativeMountPath property: All file systems are mounted relative to the Batch mounts directory,
     * accessible via the AZ_BATCH_NODE_MOUNTS_DIR environment variable.
     * 
     * @param relativeMountPath the relativeMountPath value to set.
     * @return the NfsMountConfiguration object itself.
     */
    public NfsMountConfiguration withRelativeMountPath(String relativeMountPath) {
        this.relativeMountPath = relativeMountPath;
        return this;
    }

    /**
     * Get the mountOptions property: These are 'net use' options in Windows and 'mount' options in Linux.
     * 
     * @return the mountOptions value.
     */
    public String mountOptions() {
        return this.mountOptions;
    }

    /**
     * Set the mountOptions property: These are 'net use' options in Windows and 'mount' options in Linux.
     * 
     * @param mountOptions the mountOptions value to set.
     * @return the NfsMountConfiguration object itself.
     */
    public NfsMountConfiguration withMountOptions(String mountOptions) {
        this.mountOptions = mountOptions;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (source() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property source in model NfsMountConfiguration"));
        }
        if (relativeMountPath() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property relativeMountPath in model NfsMountConfiguration"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(NfsMountConfiguration.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("source", this.source);
        jsonWriter.writeStringField("relativeMountPath", this.relativeMountPath);
        jsonWriter.writeStringField("mountOptions", this.mountOptions);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NfsMountConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NfsMountConfiguration if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the NfsMountConfiguration.
     */
    public static NfsMountConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NfsMountConfiguration deserializedNfsMountConfiguration = new NfsMountConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("source".equals(fieldName)) {
                    deserializedNfsMountConfiguration.source = reader.getString();
                } else if ("relativeMountPath".equals(fieldName)) {
                    deserializedNfsMountConfiguration.relativeMountPath = reader.getString();
                } else if ("mountOptions".equals(fieldName)) {
                    deserializedNfsMountConfiguration.mountOptions = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNfsMountConfiguration;
        });
    }
}
