// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.batch.models;

/**
 * Determines how a pool communicates with the Batch service.
 */
public enum NodeCommunicationMode {
    /**
     * Enum value Default.
     */
    DEFAULT("Default"),

    /**
     * Enum value Classic.
     */
    CLASSIC("Classic"),

    /**
     * Enum value Simplified.
     */
    SIMPLIFIED("Simplified");

    /**
     * The actual serialized value for a NodeCommunicationMode instance.
     */
    private final String value;

    NodeCommunicationMode(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a NodeCommunicationMode instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed NodeCommunicationMode object, or null if unable to parse.
     */
    public static NodeCommunicationMode fromString(String value) {
        if (value == null) {
            return null;
        }
        NodeCommunicationMode[] items = NodeCommunicationMode.values();
        for (NodeCommunicationMode item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
